/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.core.debug.processing.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.mwe.core.debug.model.NameValuePair;
import org.eclipse.emf.mwe.core.debug.processing.ElementAdapter;
import org.eclipse.emf.mwe.core.debug.processing.EventHandler;
import org.eclipse.emf.mwe.internal.core.debug.communication.Connection;
import org.eclipse.emf.mwe.internal.core.debug.communication.packages.RequireVarPackage;
import org.eclipse.emf.mwe.internal.core.debug.communication.packages.VarDataPackage;
import org.eclipse.emf.mwe.internal.core.debug.model.VarValue;
import org.eclipse.emf.mwe.internal.core.debug.model.VarValueTO;
import org.eclipse.emf.mwe.internal.core.debug.processing.DebugMonitor;
import org.eclipse.emf.mwe.internal.core.debug.processing.RuntimeHandler;

public class VariablesRuntimeHandler
implements RuntimeHandler,
EventHandler,
Runnable {
    private Connection connection;
    private DebugMonitor monitor;
    private final Stack<Frame> filteredStackFrames = new Stack();
    private final Stack<Frame> stackFrames = new Stack();
    private final List<VarValue> frameCache = new ArrayList<VarValue>();
    private final List<VarValue> varCache = new ArrayList<VarValue>();
    private int nextId = 0;

    @Override
    public void init(DebugMonitor monitor, Connection connection) {
        this.monitor = monitor;
        this.connection = connection;
        if (monitor != null) {
            monitor.addEventHandler(this);
        }
    }

    @Override
    public void startListener() {
        Thread thread = new Thread((Runnable)this, this.getClass().getSimpleName());
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.handle((RequireVarPackage)this.connection.listenForPackage(RequireVarPackage.class));
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void handle(RequireVarPackage packet) throws IOException {
        List<VarValueTO> values = packet.varId == 0 ? this.getFrameVariables(packet.frameId) : this.getSubVariables(packet.frameId, packet.varId);
        VarDataPackage varPackage = new VarDataPackage();
        if (values != null) {
            varPackage.valueList = values;
        }
        varPackage.refId = packet.getId();
        this.connection.sendPackage(varPackage);
    }

    private List<VarValueTO> getFrameVariables(int frameId) {
        if (frameId >= this.filteredStackFrames.size()) {
            return null;
        }
        Frame frame = (Frame)this.filteredStackFrames.get(frameId);
        ElementAdapter adapter = this.monitor.getAdapter(frame.element);
        adapter.setContext(frame.context);
        this.cleanFramesCache();
        VarValue hostValue = new VarValue(frame.element, 0);
        this.frameCache.add(hostValue);
        List<VarValueTO> vars = this.getVariableTOs(frame.element, hostValue, adapter);
        return vars;
    }

    private List<VarValueTO> getSubVariables(int frameId, int varId) {
        if (this.filteredStackFrames.size() <= frameId) {
            return null;
        }
        Frame frame = (Frame)this.filteredStackFrames.get(frameId);
        ElementAdapter adapter = this.monitor.getAdapter(frame.element);
        adapter.setContext(frame.context);
        VarValue value = this.findVarValueById(varId);
        if (value == null) {
            return null;
        }
        return this.getVariableTOs(value.element, value, adapter);
    }

    private List<VarValueTO> getVariableTOs(Object hostElement, VarValue hostValue, ElementAdapter adapter) {
        ArrayList<VarValueTO> list = new ArrayList<VarValueTO>();
        HashSet<VarValue> oldMembers = new HashSet<VarValue>();
        oldMembers.addAll(hostValue.members);
        hostValue.members.clear();
        for (NameValuePair entry : adapter.getVariables(hostElement)) {
            String name = entry.name;
            Object element = entry.value;
            VarValueTO varTO = new VarValueTO(name);
            if (element == null) {
                varTO.stringRep = "null";
                varTO.simpleRep = "null";
            } else if (element instanceof String) {
                varTO.stringRep = (String)element;
                varTO.simpleRep = "\"" + String.valueOf(element) + "\"";
            } else {
                VarValue value = this.findOrCreateVarValue(element);
                value.usedIn.add(hostValue);
                hostValue.members.add(value);
                oldMembers.remove(value);
                varTO.stringRep = adapter.getVariableDetailRep(element);
                varTO.simpleRep = adapter.getVariableSimpleRep(element);
                varTO.hasMembers = adapter.checkVariableHasMembers(element);
                varTO.valueId = value.id;
            }
            list.add(varTO);
        }
        for (VarValue value : oldMembers) {
            value.usedIn.remove(hostValue);
            if (!value.usedIn.isEmpty()) continue;
            this.varCache.remove(value);
        }
        return list;
    }

    private VarValue findOrCreateVarValue(Object element) {
        VarValue value = this.findVarValueByElement(element);
        if (value == null) {
            value = new VarValue(element, ++this.nextId);
            this.varCache.add(value);
        }
        return value;
    }

    private VarValue findVarValueByElement(Object element) {
        for (VarValue cacheEntry : this.varCache) {
            if (element != cacheEntry.element) continue;
            return cacheEntry;
        }
        return null;
    }

    private VarValue findVarValueById(int id) {
        for (VarValue cacheEntry : this.varCache) {
            if (id != cacheEntry.id) continue;
            return cacheEntry;
        }
        return null;
    }

    private void cleanFramesCache() {
        HashSet<VarValue> oldFrameValues = new HashSet<VarValue>();
        oldFrameValues.addAll(this.frameCache);
        for (VarValue value : oldFrameValues) {
            if (this.filteredStackFrames.contains(value.element)) continue;
            this.frameCache.remove(value);
            for (VarValue member : value.members) {
                member.usedIn.remove(value);
                if (!member.usedIn.isEmpty()) continue;
                this.varCache.remove(member);
            }
        }
    }

    @Override
    public void preTask(Object element, Object context, int state) {
        Frame frame = new Frame(element, context);
        ElementAdapter adapter = this.monitor.getAdapter(element);
        if (adapter != null && adapter.shallAddToCallStack(element)) {
            this.filteredStackFrames.push(frame);
        }
        this.stackFrames.push(frame);
    }

    @Override
    public void postTask(Object context) {
        if (this.stackFrames.isEmpty()) {
            return;
        }
        Frame frame = this.stackFrames.peek();
        ElementAdapter adapter = this.monitor.getAdapter(frame.element);
        if (adapter != null && adapter.shallAddToCallStack(frame.element)) {
            this.filteredStackFrames.pop();
        }
        this.stackFrames.pop();
    }

    @Override
    public void resumed() {
    }

    @Override
    public void suspended() {
    }

    @Override
    public void started() {
    }

    @Override
    public void terminated() {
    }

    private class Frame {
        final Object element;
        final Object context;

        private Frame(Object element, Object context) {
            this.element = element;
            this.context = context;
        }
    }
}

