/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.bndtools;

import aQute.bnd.build.Container;
import aQute.bnd.build.Workspace;
import biz.aQute.resolve.Bndrun;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.ui.bndtools.BndTargetLocation;
import org.eclipse.pde.internal.ui.bndtools.BndTargetLocationFactory;
import org.eclipse.pde.internal.ui.bndtools.RunDescriptorTargetLocationWizard;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RunDescriptorTargetLocation
extends BndTargetLocation {
    static final String TYPE = "BndRunDescriptorLocation";
    static final String ELEMENT_RUN_DESCRIPTOR = "bndrun";
    static final String ATTRIBUTE_RUN_DESCRIPTOR_FILE = "file";
    private String bndrunFileName;
    private IFile bndrunFile;

    public RunDescriptorTargetLocation() {
        super(TYPE, "bndrun.svg");
    }

    public RunDescriptorTargetLocation setRunDescriptor(IFile bndrunFile) {
        this.bndrunFileName = bndrunFile.getFullPath().toString();
        this.bndrunFile = bndrunFile;
        this.clearResolutionStatus();
        return this;
    }

    public RunDescriptorTargetLocation setRunDescriptor(String bndrunFileName) {
        this.bndrunFileName = bndrunFileName;
        this.bndrunFile = null;
        this.clearResolutionStatus();
        return this;
    }

    public IFile getFile() {
        return this.bndrunFile;
    }

    public String getText(Object element) {
        return this.bndrunFile != null ? this.bndrunFile.getFullPath().toString() : this.bndrunFileName;
    }

    @Override
    public IWizard getEditWizard(ITargetDefinition target, TreePath treePath) {
        RunDescriptorTargetLocationWizard wizard = new RunDescriptorTargetLocationWizard();
        wizard.setTarget(target);
        wizard.setTargetLocation(this);
        return wizard;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected TargetBundle[] resolveBundles(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        this.resolveBndrunFile();
        Workspace workspace = BndTargetLocation.getWorkspace();
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (Bndrun bndRun = new Bndrun(workspace, this.bndrunFile.getRawLocation().makeAbsolute().toFile());){
                Collection containers = bndRun.getRunbundles();
                ArrayList<TargetBundle> bundles = new ArrayList<TargetBundle>(containers.size());
                monitor.beginTask("Resolving Bundles", containers.size());
                int i = 0;
                Iterator iterator = containers.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        monitor.done();
                        return bundles.toArray(new TargetBundle[0]);
                    }
                    Container container = (Container)iterator.next();
                    try {
                        bundles.add(new TargetBundle(container.getFile()));
                    }
                    catch (Exception e) {
                        throw new CoreException((IStatus)new Status(4, "bndtools.pde", "Invalid plugin in run descriptor: " + container.getBundleSymbolicName() + " @ " + this.getLocation(false), (Throwable)e));
                    }
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    monitor.worked(++i);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "bndtools.pde", "Unable to resolve bundles", (Throwable)e));
        }
    }

    private void resolveBndrunFile() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Path path = new Path(this.bndrunFileName);
        IResource resource = workspace.getRoot().findMember((IPath)path);
        if (!(resource instanceof IFile)) {
            throw new CoreException((IStatus)new Status(4, "bndtools.pde", "No file at path: " + this.bndrunFileName));
        }
        this.bndrunFile = (IFile)resource;
    }

    public String getLocation(boolean resolve) {
        return this.bndrunFileName;
    }

    @Override
    protected void serialize(Document document, Element locationElement) {
        Element runDescriptorElement = document.createElement(ELEMENT_RUN_DESCRIPTOR);
        runDescriptorElement.setAttribute(ATTRIBUTE_RUN_DESCRIPTOR_FILE, this.getLocation(true));
        locationElement.appendChild(runDescriptorElement);
    }

    public void dispose() {
    }

    public static class Factory
    extends BndTargetLocationFactory {
        public Factory() {
            super(RunDescriptorTargetLocation.TYPE);
        }

        @Override
        public ITargetLocation getTargetLocation(Element locationElement) throws CoreException {
            NodeList children = locationElement.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node node = children.item(i);
                if (this.isElement(node, RunDescriptorTargetLocation.ELEMENT_RUN_DESCRIPTOR)) {
                    String file = ((Element)node).getAttribute(RunDescriptorTargetLocation.ATTRIBUTE_RUN_DESCRIPTOR_FILE);
                    return new RunDescriptorTargetLocation().setRunDescriptor(file);
                }
                ++i;
            }
            throw new CoreException((IStatus)new Status(4, "bndtools.pde", "No run descriptor file specified"));
        }
    }
}

