/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.internal.core.natures.FeatureProject;
import org.eclipse.pde.internal.core.natures.PluginProject;
import org.eclipse.pde.internal.core.natures.SiteProject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.tools.ConvertedProjectWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ConvertProjectsAction
implements IObjectActionDelegate {
    private ISelection fSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IProject[] unconverted = this.getUnconvertedProjects();
        if (unconverted.length == 0) {
            MessageDialog.openInformation((Shell)this.getDisplay().getActiveShell(), (String)PDEUIMessages.ConvertProjectsAction_find, (String)PDEUIMessages.ConvertProjectsAction_none);
            return;
        }
        if (this.fSelection instanceof IStructuredSelection) {
            Object[] elems = ((IStructuredSelection)this.fSelection).toArray();
            Vector<IProject> initialSelection = new Vector<IProject>(elems.length);
            Object[] objectArray = elems;
            int n = elems.length;
            int n2 = 0;
            while (n2 < n) {
                Object elem = objectArray[n2];
                IProject project = null;
                if (elem instanceof IFile) {
                    IFile file = (IFile)elem;
                    project = file.getProject();
                } else if (elem instanceof IProject) {
                    project = (IProject)elem;
                } else if (elem instanceof IJavaProject) {
                    project = ((IJavaProject)elem).getProject();
                }
                if (project != null) {
                    initialSelection.add(project);
                }
                ++n2;
            }
            ConvertedProjectWizard wizard = new ConvertedProjectWizard(unconverted, initialSelection);
            Display display = this.getDisplay();
            WizardDialog dialog = new WizardDialog(display.getActiveShell(), (IWizard)wizard);
            BusyIndicator.showWhile((Display)display, () -> {
                int n = dialog.open();
            });
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }

    public Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private IProject[] getUnconvertedProjects() {
        IProject[] projects;
        ArrayList<IProject> unconverted = new ArrayList<IProject>();
        IProject[] iProjectArray = projects = PDEPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen() && !PluginProject.isPluginProject((IProject)project) && !FeatureProject.isFeatureProject((IProject)project) && !SiteProject.isSiteProject((IProject)project) && project.getName().indexOf(37) == -1 && project.getLocation().toString().indexOf(37) == -1) {
                unconverted.add(project);
            }
            ++n2;
        }
        return unconverted.toArray(new IProject[unconverted.size()]);
    }
}

