/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.internal.model;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.terminal.internal.model.TerminalTextDataFastScroll;
import org.eclipse.terminal.internal.model.TerminalTextDataSnapshot;
import org.eclipse.terminal.model.ITerminalTextData;
import org.eclipse.terminal.model.ITerminalTextDataReadOnly;
import org.eclipse.terminal.model.ITerminalTextDataSnapshot;
import org.eclipse.terminal.model.LineSegment;
import org.eclipse.terminal.model.TerminalStyle;

public class TerminalTextData
implements ITerminalTextData {
    final ITerminalTextData fData;
    public TerminalTextDataSnapshot[] fSnapshots = new TerminalTextDataSnapshot[0];
    private int fCursorColumn;
    private int fCursorLine;

    public static String toMultiLineText(ITerminalTextDataReadOnly term, int start, int len) {
        if (len < 0) {
            len = term.getHeight();
        }
        StringBuffer buff = new StringBuffer();
        int width = term.getWidth();
        int n = Math.min(len, term.getHeight() - start);
        int line = start;
        while (line < n) {
            if (line > 0) {
                buff.append("\n");
            }
            int column = 0;
            while (column < width) {
                buff.append(term.getChar(line, column));
                ++column;
            }
            ++line;
        }
        int i = buff.length() - 1;
        while (i >= 0 && buff.charAt(i) == '\u0000') {
            --i;
        }
        buff.setLength(i + 1);
        return buff.toString();
    }

    public static String toMultiLineText(ITerminalTextDataReadOnly term) {
        return TerminalTextData.toMultiLineText(term, 0, 100);
    }

    public TerminalTextData() {
        this(new TerminalTextDataFastScroll());
    }

    public TerminalTextData(ITerminalTextData data) {
        this.fData = data;
    }

    @Override
    public int getWidth() {
        return this.fData.getWidth();
    }

    @Override
    public int getHeight() {
        return this.fData.getHeight();
    }

    @Override
    public void setDimensions(int height, int width) {
        int h = this.getHeight();
        int w = this.getWidth();
        if (w == width && h == height) {
            return;
        }
        this.fData.setDimensions(height, width);
        this.sendDimensionsChanged(h, w, height, width);
    }

    private void sendDimensionsChanged(int oldHeight, int oldWidth, int newHeight, int newWidth) {
        if (oldWidth == newWidth) {
            if (oldHeight < newHeight) {
                this.sendLinesChangedToSnapshot(oldHeight, newHeight - oldHeight);
            } else {
                this.sendLinesChangedToSnapshot(newHeight, oldHeight - newHeight);
            }
        } else {
            this.sendLinesChangedToSnapshot(0, oldHeight);
        }
        this.sendDimensionsChanged();
    }

    @Override
    public LineSegment[] getLineSegments(int line, int column, int len) {
        return this.fData.getLineSegments(line, column, len);
    }

    @Override
    public char getChar(int line, int column) {
        return this.fData.getChar(line, column);
    }

    @Override
    public TerminalStyle getStyle(int line, int column) {
        return this.fData.getStyle(line, column);
    }

    @Override
    public void setChar(int line, int column, char c, TerminalStyle style) {
        this.fData.setChar(line, column, c, style);
        this.sendLineChangedToSnapshots(line);
    }

    @Override
    public void setChars(int line, int column, char[] chars, TerminalStyle style) {
        this.fData.setChars(line, column, chars, style);
        this.sendLineChangedToSnapshots(line);
    }

    @Override
    public void setChars(int line, int column, char[] chars, int start, int len, TerminalStyle style) {
        this.fData.setChars(line, column, chars, start, len, style);
        this.sendLineChangedToSnapshots(line);
    }

    @Override
    public void scroll(int startLine, int size, int shift) {
        this.fData.scroll(startLine, size, shift);
        this.sendScrolledToSnapshots(startLine, size, shift);
    }

    public String toString() {
        return this.fData.toString();
    }

    private void sendDimensionsChanged() {
        int i = 0;
        while (i < this.fSnapshots.length) {
            this.fSnapshots[i].markDimensionsChanged();
            ++i;
        }
    }

    protected void sendLineChangedToSnapshots(int line) {
        int i = 0;
        while (i < this.fSnapshots.length) {
            this.fSnapshots[i].markLineChanged(line);
            ++i;
        }
    }

    protected void sendLinesChangedToSnapshot(int line, int n) {
        int i = 0;
        while (i < this.fSnapshots.length) {
            this.fSnapshots[i].markLinesChanged(line, n);
            ++i;
        }
    }

    protected void sendScrolledToSnapshots(int startLine, int size, int shift) {
        int i = 0;
        while (i < this.fSnapshots.length) {
            this.fSnapshots[i].scroll(startLine, size, shift);
            ++i;
        }
    }

    protected void sendCursorChanged() {
        int i = 0;
        while (i < this.fSnapshots.length) {
            this.fSnapshots[i].markCursorChanged();
            ++i;
        }
    }

    protected void removeSnapshot(TerminalTextDataSnapshot snapshot) {
        ArrayList<TerminalTextDataSnapshot> list = new ArrayList<TerminalTextDataSnapshot>();
        list.addAll(Arrays.asList(this.fSnapshots));
        list.remove(snapshot);
        this.fSnapshots = list.toArray(new TerminalTextDataSnapshot[list.size()]);
    }

    @Override
    public ITerminalTextDataSnapshot makeSnapshot() {
        TerminalTextDataSnapshot snapshot = new TerminalTextDataSnapshot(this);
        snapshot.markDimensionsChanged();
        ArrayList<TerminalTextDataSnapshot> list = new ArrayList<TerminalTextDataSnapshot>();
        list.addAll(Arrays.asList(this.fSnapshots));
        list.add(snapshot);
        this.fSnapshots = list.toArray(new TerminalTextDataSnapshot[list.size()]);
        return snapshot;
    }

    @Override
    public void addLine() {
        int oldHeight = this.getHeight();
        this.fData.addLine();
        int newHeight = this.getHeight();
        if (newHeight > oldHeight) {
            this.sendLinesChangedToSnapshot(oldHeight, 1);
            int width = this.getWidth();
            this.sendDimensionsChanged(oldHeight, width, newHeight, width);
        } else {
            this.sendScrolledToSnapshots(0, oldHeight, -1);
        }
    }

    @Override
    public void copy(ITerminalTextData source) {
        this.fData.copy(source);
        this.fCursorLine = source.getCursorLine();
        this.fCursorColumn = source.getCursorColumn();
    }

    @Override
    public void copyLine(ITerminalTextData source, int sourceLine, int destLine) {
        this.fData.copyLine(source, sourceLine, destLine);
    }

    @Override
    public void copyRange(ITerminalTextData source, int sourceStartLine, int destStartLine, int length) {
        this.fData.copyRange(source, sourceStartLine, destStartLine, length);
    }

    @Override
    public char[] getChars(int line) {
        return this.fData.getChars(line);
    }

    @Override
    public TerminalStyle[] getStyles(int line) {
        return this.fData.getStyles(line);
    }

    @Override
    public int getMaxHeight() {
        return this.fData.getMaxHeight();
    }

    @Override
    public void setMaxHeight(int height) {
        this.fData.setMaxHeight(height);
    }

    @Override
    public void cleanLine(int line) {
        this.fData.cleanLine(line);
        this.sendLineChangedToSnapshots(line);
    }

    @Override
    public int getCursorColumn() {
        return this.fCursorColumn;
    }

    @Override
    public int getCursorLine() {
        return this.fCursorLine;
    }

    @Override
    public void setCursorColumn(int column) {
        this.fCursorColumn = column;
        this.sendCursorChanged();
    }

    @Override
    public void setCursorLine(int line) {
        this.fCursorLine = line;
        this.sendCursorChanged();
    }

    @Override
    public boolean isWrappedLine(int line) {
        return this.fData.isWrappedLine(line);
    }

    @Override
    public void setWrappedLine(int line) {
        this.fData.setWrappedLine(line);
    }
}

