/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.launchview.internal.view;

import org.eclipse.debug.ui.launchview.internal.model.LaunchObjectModel;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LaunchViewLabelProvider
extends BaseLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final ImageDescriptor ICON_RUNNING = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.debug.ui.launchview", (String)"icons/run_co.svg");
    private final ImageRegistry perConfig = new ImageRegistry();

    public StyledString getStyledText(Object element) {
        if (element instanceof LaunchObjectModel) {
            return ((LaunchObjectModel)element).getLabel();
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof LaunchObjectModel) {
            LaunchObjectModel obj = (LaunchObjectModel)element;
            if (obj.getObject() != null && obj.getObject().canTerminate()) {
                return this.getCachedRunningImage(obj);
            }
            return obj.getImage();
        }
        return null;
    }

    private Image getCachedRunningImage(LaunchObjectModel obj) {
        Image img = this.perConfig.get(obj.getObject().getId());
        if (img == null) {
            img = new DecorationOverlayIcon(obj.getImage(), ICON_RUNNING, 0).createImage();
            this.perConfig.put(obj.getObject().getId(), img);
        }
        return img;
    }

    public void dispose() {
        this.perConfig.dispose();
        super.dispose();
    }
}

