/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.ui.target.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.m2e.pde.target.MavenTargetDependency;
import org.eclipse.m2e.pde.target.MavenTargetLocation;
import org.eclipse.pde.core.target.TargetFeature;

public class MavenTargetTreeContentProvider
implements ITreeContentProvider {
    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof MavenTargetLocation) {
            MavenTargetLocation location = (MavenTargetLocation)parentElement;
            ArrayList<Object> childs = new ArrayList<Object>();
            List roots = location.getRoots();
            if (roots.size() == 1) {
                childs.addAll(Arrays.asList(this.getDependencyChilds((MavenTargetDependency)roots.get(0), parentElement)));
            } else {
                childs.addAll(roots);
            }
            TargetFeature[] features = location.getFeatures();
            if (features != null && features.length > 0) {
                childs.addAll(Arrays.asList(features));
            }
            return childs.toArray();
        }
        if (parentElement instanceof DependencyNode) {
            Object[] dependencyNodes;
            DependencyNode dependency = (DependencyNode)parentElement;
            Object[] objectArray = dependencyNodes = (DependencyNode[])dependency.getChildren().stream().filter(d -> d.getArtifact().getFile() != null).toArray(DependencyNode[]::new);
            int n = dependencyNodes.length;
            int n2 = 0;
            while (n2 < n) {
                Object dependencyNode = objectArray[n2];
                dependencyNode.setData((Object)"dependencynode.parent", parentElement);
                ++n2;
            }
            return dependencyNodes;
        }
        if (parentElement instanceof MavenTargetDependency) {
            MavenTargetDependency dependency = (MavenTargetDependency)parentElement;
            return this.getDependencyChilds(dependency, parentElement);
        }
        return new Object[0];
    }

    private Object[] getDependencyChilds(MavenTargetDependency targetDependency, Object parentElement) {
        List nodes = targetDependency.getDependencyNodes();
        if (nodes != null) {
            for (DependencyNode dependencyNode : nodes) {
                if (!dependencyNode.getData().containsKey("dependencynode.root")) continue;
                dependencyNode.setData((Object)"dependencynode.parent", parentElement);
                return this.getChildren(dependencyNode);
            }
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof DependencyNode) {
            DependencyNode dp;
            DependencyNode dependencyNode = (DependencyNode)element;
            Object parent = dependencyNode.getData().get("dependencynode.parent");
            if (parent instanceof DependencyNode && (dp = (DependencyNode)parent).getData().containsKey("dependencynode.root")) {
                return this.getParent(dp);
            }
            return parent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof MavenTargetLocation) {
            MavenTargetLocation location = (MavenTargetLocation)element;
            return !location.getRoots().isEmpty();
        }
        if (element instanceof DependencyNode) {
            DependencyNode node = (DependencyNode)element;
            return !node.getChildren().isEmpty();
        }
        if (element instanceof MavenTargetDependency) {
            MavenTargetDependency targetDependency = (MavenTargetDependency)element;
            List dependencyNodes = targetDependency.getDependencyNodes();
            return dependencyNodes != null && !dependencyNodes.isEmpty();
        }
        return false;
    }
}

