/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.core;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.CollaboratorService;
import org.eclipse.mylyn.internal.github.core.GitHubAttributeMetadata;
import org.eclipse.mylyn.internal.github.core.GitHubTaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;

public abstract class GitHubTaskDataHandler
extends AbstractTaskDataHandler {
    public TaskAttributeMapper getAttributeMapper(TaskRepository taskRepository) {
        return new GitHubTaskAttributeMapper(taskRepository);
    }

    protected TaskAttribute setPersonValue(TaskData data, TaskAttribute attribute, User user, TaskRepository repository) {
        if (user != null) {
            data.getAttributeMapper().setRepositoryPerson(attribute, this.createPerson(user, repository));
        }
        return attribute;
    }

    protected IRepositoryPerson createPerson(User user, TaskRepository repository) {
        IRepositoryPerson person = repository.createPerson(user.getLogin());
        person.setName(user.getName());
        return person;
    }

    protected TaskAttribute setDateValue(TaskData data, TaskAttribute attribute, Date date) {
        if (date != null) {
            data.getAttributeMapper().setDateValue(attribute, date);
        }
        return attribute;
    }

    protected void addComments(TaskAttribute parent, List<Comment> comments, TaskRepository repository) {
        if (comments == null || comments.isEmpty()) {
            return;
        }
        int count = 1;
        for (Comment comment : comments) {
            TaskCommentMapper commentMapper = new TaskCommentMapper();
            commentMapper.setAuthor(this.createPerson(comment.getUser(), repository));
            commentMapper.setCreationDate(comment.getCreatedAt());
            commentMapper.setText(comment.getBody());
            commentMapper.setCommentId(comment.getUrl());
            commentMapper.setNumber(Integer.valueOf(count));
            TaskAttribute attribute = parent.createAttribute("task.common.comment-" + count);
            commentMapper.applyTo(attribute);
            ++count;
        }
    }

    protected String getAttributeValue(TaskData taskData, GitHubAttributeMetadata attr) {
        TaskAttribute attribute = taskData.getRoot().getAttribute(attr.getId());
        return attribute == null ? null : attribute.getValue();
    }

    protected TaskAttribute createAttribute(TaskData data, GitHubAttributeMetadata attribute) {
        TaskAttribute attr = data.getRoot().createAttribute(attribute.getId());
        TaskAttributeMetaData metaData = attr.getMetaData();
        metaData.defaults().setType(attribute.getType()).setKind(attribute.getKind()).setLabel(attribute.getLabel()).setReadOnly(attribute.isReadOnly());
        return attr;
    }

    protected TaskAttribute createAttribute(TaskData data, GitHubAttributeMetadata metadata, String value) {
        TaskAttribute attr = this.createAttribute(data, metadata);
        if (value != null) {
            data.getAttributeMapper().setValue(attr, value);
        }
        return attr;
    }

    protected TaskAttribute createAttribute(TaskData data, GitHubAttributeMetadata metadata, Date date) {
        return this.setDateValue(data, this.createAttribute(data, metadata), date);
    }

    protected TaskAttribute createAttribute(TaskData data, GitHubAttributeMetadata metadata, User user, TaskRepository repository) {
        return this.setPersonValue(data, this.createAttribute(data, metadata), user, repository);
    }

    protected TaskAttribute createOperationAttribute(TaskData data) {
        TaskAttribute attribute = data.getRoot().createAttribute("task.common.operation");
        attribute.getMetaData().setType("operation");
        return attribute;
    }

    protected TaskAttribute addOperation(TaskData data, String id, String label, boolean isDefault) {
        TaskAttribute root = data.getRoot();
        TaskAttribute attribute = root.createAttribute("task.common.operation-" + id);
        TaskOperation.applyTo((TaskAttribute)attribute, (String)id, (String)label);
        if (isDefault) {
            TaskOperation.applyTo((TaskAttribute)root.getAttribute("task.common.operation"), (String)id, (String)label);
        }
        return attribute;
    }

    protected boolean attributeMatchesUser(GitHubClient client, GitHubAttributeMetadata metadata, TaskData data) {
        if (client == null || metadata == null || data == null) {
            return false;
        }
        String user = client.getUser();
        if (user == null || user.length() == 0) {
            return false;
        }
        return metadata.getValue(data).equals(user);
    }

    protected boolean isCollaborator(GitHubClient client, RepositoryId repo) throws IOException {
        String user = client.getUser();
        if (user == null || user.length() == 0) {
            return false;
        }
        return new CollaboratorService(client).isCollaborator((IRepositoryIdProvider)repo, user);
    }
}

