/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.internal.parser.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.mylyn.wikitext.internal.parser.html.AbstractSaxHtmlParser;
import org.eclipse.mylyn.wikitext.internal.util.ConcatenatingReader;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XHtmlParser
extends AbstractSaxHtmlParser {
    @Override
    protected void parse(InputSource input, DocumentBuilder builder, ContentHandler contentHandler) throws IOException, SAXException {
        if (input == null || builder == null) {
            throw new IllegalArgumentException();
        }
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setContentHandler(contentHandler);
        Reader reader = input.getCharacterStream();
        if (reader == null) {
            InputStream in = input.getByteStream();
            if (in == null) {
                throw new IllegalArgumentException("input must provide a byte stream or a character stream");
            }
            reader = new InputStreamReader(in, input.getEncoding() == null ? "utf-8" : input.getEncoding());
        }
        reader = new ConcatenatingReader(new StringReader("<?xml version='1.0'?><!DOCTYPE html [ <!ENTITY nbsp \"&#160;\"> <!ENTITY copy \"&#169;\"> <!ENTITY reg \"&#174;\"> <!ENTITY euro \"&#8364;\"> ]>"), reader);
        input = new InputSource(reader);
        xmlReader.parse(input);
    }
}

