/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.colors;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.dataprovider.X11ColorUtils;

public final class ColorUtils {
    private static final String HEX_COLOR_FORMAT = "#%02x%02x%02x";
    private static final String HEX_COLOR_REGEX = "#[A-Fa-f0-9]{6}";
    private static final LoadingCache<RGB, String> HEX_COLOR_CACHE = CacheBuilder.newBuilder().maximumSize(1024L).build((CacheLoader)new CacheLoader<RGB, String>(){

        public String load(RGB rgb) throws Exception {
            int r = rgb.red;
            int g = rgb.green;
            int b = rgb.blue;
            return String.format(ColorUtils.HEX_COLOR_FORMAT, r, g, b);
        }
    });

    private ColorUtils() {
    }

    public static RGB fromHexColor(String color) {
        if (color != null && color.matches(HEX_COLOR_REGEX)) {
            return new RGB(Integer.valueOf(color.substring(1, 3), 16).intValue(), Integer.valueOf(color.substring(3, 5), 16).intValue(), Integer.valueOf(color.substring(5, 7), 16).intValue());
        }
        return null;
    }

    public static @NonNull String toHexColor(RGB rgb) {
        try {
            return Objects.requireNonNull((String)HEX_COLOR_CACHE.get((Object)rgb));
        }
        catch (ExecutionException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            int r = rgb.red;
            int g = rgb.green;
            int b = rgb.blue;
            return String.format(HEX_COLOR_FORMAT, r, g, b);
        }
    }

    public static @NonNull String toHexColor(int red, int green, int blue) {
        return ColorUtils.toHexColor(new RGB(Math.abs(red % 256), Math.abs(green % 256), Math.abs(blue % 256)));
    }

    public static RGB fromX11Color(String x11ColorName) {
        return x11ColorName == null ? null : ColorUtils.fromHexColor(X11ColorUtils.toHexColor((String)x11ColorName));
    }
}

