/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.internal.core.builder.Messages;

class ExternalModuleCollector
implements IModelElementVisitor {
    final List<ISourceModule> elements = new ArrayList<ISourceModule>();
    private final IProgressMonitor monitor;

    public ExternalModuleCollector(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public boolean visit(IModelElement element) {
        if (this.monitor.isCanceled()) {
            return false;
        }
        if (element.getElementType() == 3) {
            if (!(element instanceof IProjectFragment) || !((IProjectFragment)element).isExternal()) {
                return false;
            }
            IProjectFragment fragment = (IProjectFragment)element;
            String localPath = EnvironmentPathUtils.getLocalPath(fragment.getPath()).toString();
            if (!localPath.startsWith("#")) {
                this.monitor.subTask(Messages.ScriptBuilder_scanningExternalFolder + localPath);
            }
        } else {
            IScriptFolder folder;
            String localPath;
            if (element.getElementType() == 5) {
                if (element instanceof IExternalSourceModule || element instanceof BuiltinSourceModule) {
                    this.elements.add((ISourceModule)element);
                }
                return false;
            }
            if (element.getElementType() == 4 && !(localPath = EnvironmentPathUtils.getLocalPath((folder = (IScriptFolder)element).getPath()).toString()).startsWith("#")) {
                this.monitor.subTask(Messages.ScriptBuilder_scanningExternalFolder + localPath);
            }
        }
        return true;
    }
}

