/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.WrongGitFlowStateException;
import org.eclipse.egit.gitflow.op.GitFlowOperation;
import org.eclipse.egit.gitflow.op.ReleaseStartOperation;
import org.eclipse.egit.gitflow.ui.internal.JobFamilies;
import org.eclipse.egit.gitflow.ui.internal.UIText;
import org.eclipse.egit.gitflow.ui.internal.actions.GitFlowHandlerUtil;
import org.eclipse.egit.gitflow.ui.internal.actions.PostBranchCheckoutUiTask;
import org.eclipse.egit.gitflow.ui.internal.actions.StartDialog;
import org.eclipse.egit.gitflow.ui.internal.validation.ReleaseNameValidator;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ReleaseStartHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        GitFlowRepository gfRepo = GitFlowHandlerUtil.getRepository(event);
        if (gfRepo == null) {
            return null;
        }
        String startCommitSha1 = this.getStartCommit(event);
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        this.doExecute(gfRepo, startCommitSha1, activeShell);
        return null;
    }

    void doExecute(GitFlowRepository gfRepo, String startCommitSha1, Shell activeShell) {
        StartDialog inputDialog = new StartDialog(activeShell, UIText.ReleaseStartHandler_provideReleaseName, UIText.ReleaseStartHandler_provideANameForTheNewRelease, "", new ReleaseNameValidator(gfRepo));
        if (inputDialog.open() != 0) {
            return;
        }
        String releaseName = inputDialog.getValue();
        ReleaseStartOperation operation = new ReleaseStartOperation(gfRepo, startCommitSha1, releaseName);
        String fullBranchName = gfRepo.getConfig().getFullReleaseBranchName(releaseName);
        JobUtil.scheduleUserWorkspaceJob((IEGitOperation)operation, (String)UIText.ReleaseStartHandler_startingNewRelease, (Object)JobFamilies.GITFLOW_FAMILY, (IJobChangeListener)new PostBranchCheckoutUiTask(gfRepo, fullBranchName, (GitFlowOperation)operation));
    }

    private String getStartCommit(ExecutionEvent event) throws ExecutionException {
        RevCommit head;
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IStructuredSelection selection = SelectionUtils.getStructuredSelection((ISelection)currentSelection);
        if (selection.getFirstElement() instanceof PlotCommit) {
            RevCommit plotCommit = (RevCommit)selection.getFirstElement();
            return plotCommit.getName();
        }
        GitFlowRepository gitFlowRepository = GitFlowHandlerUtil.getRepository(event);
        if (gitFlowRepository == null) {
            throw new ExecutionException(UIText.ReleaseStartHandler_startCommitCouldNotBeDetermined);
        }
        try {
            head = gitFlowRepository.findHead();
        }
        catch (WrongGitFlowStateException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        return head.getName();
    }
}

