/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.launching.VMDefinitionsContainer;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public class JREsUpdater {
    private final VMDefinitionsContainer fOriginalVMs = new VMDefinitionsContainer();

    public JREsUpdater() {
        IVMInstall def = JavaRuntime.getDefaultVMInstall();
        if (def != null) {
            this.fOriginalVMs.setDefaultVMInstallCompositeID(JavaRuntime.getCompositeIdFromVM((IVMInstall)def));
        }
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstall[] vms = types[i].getVMInstalls();
            int j = 0;
            while (j < vms.length) {
                this.fOriginalVMs.addVM(vms[j]);
                ++j;
            }
            ++i;
        }
    }

    public boolean updateJRESettings(IVMInstall[] jres, IVMInstall defaultJRE) {
        VMDefinitionsContainer vmContainer = new VMDefinitionsContainer();
        String defaultVMId = JavaRuntime.getCompositeIdFromVM((IVMInstall)defaultJRE);
        vmContainer.setDefaultVMInstallCompositeID(defaultVMId);
        int i = 0;
        while (i < jres.length) {
            vmContainer.addVM(jres[i]);
            ++i;
        }
        this.saveVMDefinitions(vmContainer);
        return true;
    }

    private void saveVMDefinitions(final VMDefinitionsContainer container) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(JREMessages.JREsUpdater_0, 100);
                        String vmDefXML = container.getAsXML();
                        monitor.worked(40);
                        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.launching");
                        if (prefs != null) {
                            prefs.put(JavaRuntime.PREF_VM_XML, vmDefXML);
                        }
                        monitor.worked(30);
                        JavaRuntime.savePreferences();
                        monitor.worked(30);
                    }
                    catch (CoreException e) {
                        JDIDebugUIPlugin.log(e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            JDIDebugUIPlugin.log(e);
        }
        catch (InterruptedException e) {
            JDIDebugUIPlugin.log(e);
        }
    }
}

