/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.binaryproject.internal.sourcelookup;

import java.io.File;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.sourcelookup.advanced.AdvancedSourceLookup;
import org.eclipse.jdt.launching.sourcelookup.containers.PackageFragmentRootSourceContainer;
import org.eclipse.m2e.binaryproject.internal.sourcelookup.BinaryProjectDescriber;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.sourcelookup.internal.launch.MavenSourceContainerResolver;

public class BinaryProjectContainerResolver
extends MavenSourceContainerResolver {
    protected ISourceContainer resolveSourceContainer(ArtifactKey artifact, IProgressMonitor monitor) {
        IPackageFragmentRoot binary;
        block6: {
            File binaryLocation;
            IProject project;
            block5: {
                String groupId = artifact.groupId();
                String artifactId = artifact.artifactId();
                String version = artifact.version();
                IMavenProjectRegistry projectRegistry = MavenPlugin.getMavenProjectRegistry();
                IMavenProjectFacade mavenProject = projectRegistry.getMavenProject(groupId, artifactId, version);
                if (mavenProject == null) {
                    return null;
                }
                project = mavenProject.getProject();
                try {
                    binaryLocation = BinaryProjectDescriber.getBinaryLocation(project);
                    if (binaryLocation != null) break block5;
                    return null;
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            IJavaProject javaProject = JavaCore.create((IProject)project);
            Map classpath = AdvancedSourceLookup.getClasspath((IJavaProject)javaProject);
            binary = (IPackageFragmentRoot)classpath.remove(binaryLocation);
            if (binary != null) break block6;
            return null;
        }
        return new PackageFragmentRootSourceContainer(binary);
    }
}

