/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bnd;

import aQute.bnd.build.Project;
import aQute.bnd.osgi.resource.ResourceBuilder;
import java.io.InputStream;
import java.util.jar.Manifest;
import org.bndtools.versioncontrol.ignores.manager.api.VersionControlIgnoresManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.AdapterTypes;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.pde.internal.core.bnd.BndProjectManager;
import org.eclipse.pde.internal.core.natures.PluginProject;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.osgi.resource.Resource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@AdapterTypes(adaptableClass={IProject.class}, adapterNames={Project.class, VersionControlIgnoresManager.class, Resource.class})
@Component(service={IAdapterFactory.class})
public class PdeBndAdapter
implements IAdapterFactory {
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    private volatile VersionControlIgnoresManager versionControlIgnoresManager;

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        IFile manifestFile;
        IProject project;
        if (adapterType == Project.class && adaptableObject instanceof IProject) {
            IProject project2 = (IProject)adaptableObject;
            try {
                return adapterType.cast(BndProjectManager.getBndProject(project2).orElse(null));
            }
            catch (Exception e) {
                return null;
            }
        }
        if (adapterType == VersionControlIgnoresManager.class) {
            return adapterType.cast(this.versionControlIgnoresManager);
        }
        if (adapterType == Resource.class && adaptableObject instanceof IProject && PluginProject.isPluginProject(project = (IProject)adaptableObject) && (manifestFile = PDEProject.getManifest(project)) != null && manifestFile.exists()) {
            Manifest manifest;
            try {
                Throwable throwable = null;
                Object var7_10 = null;
                try (InputStream stream = manifestFile.getContents();){
                    manifest = new Manifest(stream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                return null;
            }
            ResourceBuilder builder = new ResourceBuilder();
            builder.addManifest(manifest);
            return adapterType.cast(builder.build());
        }
        return null;
    }
}

