/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.twiki.internal.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.Block;
import org.eclipse.mylyn.wikitext.twiki.TWikiLanguage;

public class LiteralBlock
extends Block {
    private static final Pattern startPattern = Pattern.compile("\\s*<literal>(.*)");
    private static final Pattern endPattern = Pattern.compile("\\s*</literal>(.*)");
    private int blockLineCount = 0;
    private Matcher matcher;

    public int processLineContent(String line, int offset) {
        if (this.blockLineCount++ == 0) {
            offset = this.matcher.start(1);
            ((TWikiLanguage)this.markupLanguage).setLiteralMode(true);
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        } else {
            Matcher endMatcher = endPattern.matcher(line);
            if (endMatcher.matches()) {
                this.setClosed(true);
                return endMatcher.start(1);
            }
        }
        this.markupLanguage.emitMarkupLine(this.parser, this.state, line, offset);
        this.builder.characters("\n");
        return -1;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
            ((TWikiLanguage)this.markupLanguage).setLiteralMode(false);
        }
        super.setClosed(closed);
    }

    public boolean canStart(String line, int lineOffset) {
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            this.blockLineCount = 0;
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }
}

