/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;

public abstract class KnnVectorValues {
    public abstract int dimension();

    public abstract int size();

    public int ordToDoc(int ord) {
        return ord;
    }

    public abstract KnnVectorValues copy() throws IOException;

    public int getVectorByteLength() {
        return this.dimension() * this.getEncoding().byteSize;
    }

    public abstract VectorEncoding getEncoding();

    public Bits getAcceptOrds(final Bits acceptDocs) {
        if (acceptDocs == null) {
            return null;
        }
        return new Bits(){

            @Override
            public boolean get(int index) {
                return acceptDocs.get(KnnVectorValues.this.ordToDoc(index));
            }

            @Override
            public int length() {
                return KnnVectorValues.this.size();
            }
        };
    }

    public DocIndexIterator iterator() {
        throw new UnsupportedOperationException();
    }

    protected DocIndexIterator createDenseIterator() {
        return new DocIndexIterator(){
            int doc = -1;

            @Override
            public int docID() {
                return this.doc;
            }

            @Override
            public int index() {
                return this.doc;
            }

            @Override
            public int nextDoc() throws IOException {
                if (this.doc >= KnnVectorValues.this.size() - 1) {
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                return ++this.doc;
            }

            @Override
            public int advance(int target) {
                if (target >= KnnVectorValues.this.size()) {
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.doc = target;
                return this.doc;
            }

            @Override
            public long cost() {
                return KnnVectorValues.this.size();
            }
        };
    }

    protected static DocIndexIterator fromDISI(final DocIdSetIterator docsWithField) {
        return new DocIndexIterator(){
            int ord = -1;

            @Override
            public int docID() {
                return docsWithField.docID();
            }

            @Override
            public int index() {
                return this.ord;
            }

            @Override
            public int nextDoc() throws IOException {
                if (this.docID() == Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                ++this.ord;
                return docsWithField.nextDoc();
            }

            @Override
            public int advance(int target) throws IOException {
                return docsWithField.advance(target);
            }

            @Override
            public long cost() {
                return docsWithField.cost();
            }
        };
    }

    protected DocIndexIterator createSparseIterator() {
        return new DocIndexIterator(){
            private int ord = -1;

            @Override
            public int docID() {
                if (this.ord == -1) {
                    return -1;
                }
                if (this.ord == Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                return KnnVectorValues.this.ordToDoc(this.ord);
            }

            @Override
            public int index() {
                return this.ord;
            }

            @Override
            public int nextDoc() throws IOException {
                this.ord = this.ord >= KnnVectorValues.this.size() - 1 ? Integer.MAX_VALUE : ++this.ord;
                return this.docID();
            }

            @Override
            public int advance(int target) throws IOException {
                return this.slowAdvance(target);
            }

            @Override
            public long cost() {
                return KnnVectorValues.this.size();
            }
        };
    }

    public static abstract class DocIndexIterator
    extends DocIdSetIterator {
        public abstract int index();
    }
}

