/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.xhtml;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.help.internal.search.ASCIIReader;

public class XHTMLContentDescriber
implements IContentDescriber {
    private static final String XHTML_DTD_PREFIX = "http://www.w3.org/TR/xhtml";
    public static final int BUFFER_SIZE = 4096;

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ASCIIReader reader = new ASCIIReader(contents, 4096);){
                char[] chars = new char[4096];
                reader.read(chars);
                String str = new String(chars);
                int n = str.contains(XHTML_DTD_PREFIX) ? 2 : 0;
                return n;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return 1;
        }
    }

    public QualifiedName[] getSupportedOptions() {
        return new QualifiedName[0];
    }
}

