/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightingWithOwnPreference;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.ISemanticHighlighter;
import org.eclipse.cdt.ui.text.ISemanticToken;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;

public class ContributedSemanticHighlighting
extends SemanticHighlightingWithOwnPreference {
    private IConfigurationElement configurationElement;
    private Boolean fStatus = null;
    private ISemanticHighlighter semanticHighlighter;
    private final Expression enablementExpression;
    private final int priority;
    private final String id;
    private final String preferenceKey;
    private final String displayName;
    private final RGB defaultTextColor;
    private final boolean defaultBold;
    private final boolean defaultItalic;
    private final boolean defaultStrikethrough;
    private final boolean defaultUnderline;
    private final boolean defaultEnabled;
    private static final String Attr_Class = "class";
    private static final String Attr_Priority = "priority";
    private static final String Attr_PrefKey = "preferenceKey";
    private static final String Attr_DisplayName = "displayName";
    private static final String Attr_DefaultTextColor = "defaultTextColor";
    private static final String Attr_DefaultBold = "defaultBold";
    private static final String Attr_DefaultItalic = "defaultItalic";
    private static final String Attr_DefaultStrikethrough = "defaultStrikethrough";
    private static final String Attr_DefaultUnderline = "defaultUnderline";
    private static final String Attr_DefaultEnabled = "defaultEnabled";
    private static final String Var_projectNature = "projectNatures";
    private static final String Var_languageId = "languageId";
    private static final int Default_Priority = 1000;

    public ContributedSemanticHighlighting(IConfigurationElement element) {
        this.configurationElement = element;
        this.id = element.getDeclaringExtension().getNamespaceIdentifier() + "." + element.getDeclaringExtension().getSimpleIdentifier();
        int pri = 1000;
        String priStr = element.getAttribute(Attr_Priority);
        if (priStr != null) {
            try {
                pri = Integer.parseInt(priStr);
            }
            catch (NumberFormatException e) {
                CUIPlugin.log("Error in priority attribute of " + this.id + " was " + priStr, e);
            }
        }
        this.priority = pri;
        Expression expr = null;
        IConfigurationElement[] children = element.getChildren("enablement");
        switch (children.length) {
            case 0: {
                this.fStatus = Boolean.TRUE;
                break;
            }
            case 1: {
                try {
                    ExpressionConverter parser = ExpressionConverter.getDefault();
                    expr = parser.perform(children[0]);
                }
                catch (CoreException e) {
                    CUIPlugin.log("Error in enablement expression of " + this.id, e);
                }
                break;
            }
            default: {
                CUIPlugin.logError("Too many enablement expressions for " + this.id);
                this.fStatus = Boolean.FALSE;
            }
        }
        this.enablementExpression = expr;
        this.preferenceKey = element.getAttribute(Attr_PrefKey);
        this.displayName = element.getAttribute(Attr_DisplayName);
        this.defaultTextColor = ContributedSemanticHighlighting.getRGBAttribute(element, this.id, Attr_DefaultTextColor);
        this.defaultBold = Boolean.parseBoolean(element.getAttribute(Attr_DefaultBold));
        this.defaultItalic = Boolean.parseBoolean(element.getAttribute(Attr_DefaultItalic));
        this.defaultStrikethrough = Boolean.parseBoolean(element.getAttribute(Attr_DefaultStrikethrough));
        this.defaultUnderline = Boolean.parseBoolean(element.getAttribute(Attr_DefaultUnderline));
        this.defaultEnabled = Boolean.parseBoolean(element.getAttribute(Attr_DefaultEnabled));
    }

    public String getId() {
        return this.id;
    }

    public int getPriority() {
        return this.priority;
    }

    private static RGB getRGBAttribute(IConfigurationElement element, String extensionId, String key) {
        String val = element.getAttribute(key);
        if (val != null) {
            try {
                return StringConverter.asRGB((String)val);
            }
            catch (DataFormatException e) {
                CUIPlugin.log("Error in defaultTextColor attribute of " + extensionId + " " + val + " is not a RGB value", e);
            }
        }
        return new RGB(0, 0, 0);
    }

    private ISemanticHighlighter createSemanticHighlighter() {
        if (this.configurationElement == null) {
            return null;
        }
        IConfigurationElement element = this.configurationElement;
        this.configurationElement = null;
        try {
            return (ISemanticHighlighter)element.createExecutableExtension(Attr_Class);
        }
        catch (CoreException e) {
            CUIPlugin.log("Error in class attribute of " + this.id, e);
            return null;
        }
    }

    @Override
    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    @Override
    public RGB getDefaultDefaultTextColor() {
        return this.defaultTextColor;
    }

    @Override
    public boolean isBoldByDefault() {
        return this.defaultBold;
    }

    @Override
    public boolean isItalicByDefault() {
        return this.defaultItalic;
    }

    @Override
    public boolean isStrikethroughByDefault() {
        return this.defaultStrikethrough;
    }

    @Override
    public boolean isUnderlineByDefault() {
        return this.defaultUnderline;
    }

    @Override
    public boolean isEnabledByDefault() {
        return this.defaultEnabled;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean requiresImplicitNames() {
        return false;
    }

    private boolean matches(ITranslationUnit tu) {
        if (this.fStatus != null) {
            return this.fStatus;
        }
        if (this.enablementExpression != null) {
            try {
                EvaluationContext evalContext = new EvaluationContext(null, (Object)tu);
                ICProject cProject = tu.getCProject();
                String[] natures = cProject.getProject().getDescription().getNatureIds();
                evalContext.addVariable(Var_projectNature, Arrays.asList(natures));
                ILanguage language = tu.getLanguage();
                if (language != null) {
                    evalContext.addVariable(Var_languageId, (Object)language.getId());
                }
                return this.enablementExpression.evaluate((IEvaluationContext)evalContext) == EvaluationResult.TRUE;
            }
            catch (CoreException e) {
                CUIPlugin.log("Error while evaluating enablement expression for " + this.id, e);
            }
        }
        this.fStatus = Boolean.FALSE;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISemanticHighlighter getSemanticHighlighter(ITranslationUnit tu) {
        if (!this.matches(tu)) {
            return null;
        }
        if (this.semanticHighlighter == null) {
            ContributedSemanticHighlighting contributedSemanticHighlighting = this;
            synchronized (contributedSemanticHighlighting) {
                if (this.semanticHighlighter == null) {
                    this.semanticHighlighter = this.createSemanticHighlighter();
                }
            }
        }
        return this.semanticHighlighter;
    }

    @Override
    public boolean consumes(ISemanticToken token) {
        if (token == null) {
            return false;
        }
        IASTTranslationUnit astTU = token.getRoot();
        if (astTU == null) {
            return false;
        }
        ITranslationUnit tu = astTU.getOriginatingTranslationUnit();
        if (tu == null) {
            return false;
        }
        ISemanticHighlighter highlighter = this.getSemanticHighlighter(tu);
        if (highlighter == null) {
            return false;
        }
        return highlighter.consumes(token);
    }
}

