/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.projection;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.ui.internal.projection.CSSRuleFoldingPosition;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.projection.AbstractStructuredFoldingStrategy;

public class CSSFoldingStrategy
extends AbstractStructuredFoldingStrategy {
    protected Position calcNewFoldPosition(IndexedRegion indexedRegion) {
        CSSRuleFoldingPosition newPos = null;
        if (indexedRegion.getStartOffset() >= 0 && indexedRegion.getLength() >= 0) {
            newPos = new CSSRuleFoldingPosition(indexedRegion);
        }
        return newPos;
    }

    protected void updateAnnotations(Iterator existingAnnotationsIter, IndexedRegion dirtyRegion, List modifications, List deletions) {
        while (existingAnnotationsIter.hasNext()) {
            Object obj = existingAnnotationsIter.next();
            if (!(obj instanceof AbstractStructuredFoldingStrategy.FoldingAnnotation)) continue;
            AbstractStructuredFoldingStrategy.FoldingAnnotation annotation = (AbstractStructuredFoldingStrategy.FoldingAnnotation)obj;
            Position newPos = this.calcNewFoldPosition(annotation.getRegion());
            if (newPos != null) {
                Position oldPos = this.fProjectionAnnotationModel.getPosition((Annotation)annotation);
                if (newPos.equals((Object)oldPos)) continue;
                oldPos.setOffset(newPos.offset);
                oldPos.setLength(newPos.length);
                modifications.add(annotation);
                continue;
            }
            deletions.add(annotation);
        }
    }

    protected boolean indexedRegionValidType(IndexedRegion indexedRegion) {
        return indexedRegion instanceof ICSSStyleRule;
    }
}

