/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.xerces.dom.DocumentImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wst.xsd.contentmodel.internal.XSDImpl;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.AddNewCategoryDialog;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.ExtensionsSchemasRegistry;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.SpecificationForExtensionsSchema;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AddExtensionsComponentDialog
extends SelectionDialog
implements ISelectionChangedListener,
SelectionListener {
    protected static final Image DEFAULT_ELEMENT_ICON = XSDEditorPlugin.getXSDImage("icons/XSDElement.gif");
    protected static final Image DEFAULT_ATTRIBUTE_ICON = XSDEditorPlugin.getXSDImage("icons/XSDAttribute.gif");
    protected static Document tempDoc = new DocumentImpl();
    Button addButton;
    Button removeButton;
    Button editButton;
    private List fInput;
    private TableViewer categoryTableViewer;
    private TableViewer elementTableViewer;
    private ArrayList existingNames;
    private ViewerFilter elementTableViewerFilter;
    private SpecificationForExtensionsSchema currentExtCategory;
    private HashMap specToComponentsList = new HashMap();
    private IPreferenceStore prefStore;

    public AddExtensionsComponentDialog(Shell parent, ExtensionsSchemasRegistry schemaRegistry) {
        super(parent);
        this.setTitle(Messages._UI_ACTION_ADD_EXTENSION_COMPONENTS);
        this.setShellStyle(65616);
    }

    public void setInput(List input) {
        this.fInput = input;
    }

    public SpecificationForExtensionsSchema getSelectedCategory() {
        return this.currentExtCategory;
    }

    public void setInitialCategorySelection(SpecificationForExtensionsSchema spec) {
        this.currentExtCategory = spec;
    }

    protected IStructuredContentProvider getCategoryContentProvider() {
        return new CategoryContentProvider();
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        Composite categoryComposite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        GridData data = new GridData(1808);
        categoryComposite.setLayoutData((Object)data);
        categoryComposite.setLayout((Layout)gl);
        Label label = new Label(categoryComposite, 16384);
        label.setText(Messages._UI_LABEL_EXTENSION_CATEGORIES);
        new Label(categoryComposite, 0);
        this.categoryTableViewer = new TableViewer(categoryComposite, this.getTableStyle());
        this.categoryTableViewer.setContentProvider((IContentProvider)this.getCategoryContentProvider());
        this.categoryTableViewer.setLabelProvider((IBaseLabelProvider)new CategoryLabelProvider());
        this.categoryTableViewer.setInput((Object)this.fInput);
        this.categoryTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.categoryTableViewer.getControl(), "org.eclipse.wst.xsd.ui.xsdud0130");
        GridData gd = new GridData(1808);
        Table table = this.categoryTableViewer.getTable();
        table.setLayoutData((Object)gd);
        table.setFont(container.getFont());
        Composite buttonComposite = new Composite(categoryComposite, 0);
        gl = new GridLayout();
        gl.makeColumnsEqualWidth = true;
        gl.numColumns = 1;
        data = new GridData();
        data.horizontalAlignment = 4;
        buttonComposite.setLayoutData((Object)data);
        buttonComposite.setLayout((Layout)gl);
        this.addButton = new Button(buttonComposite, 8);
        this.addButton.setText(Messages._UI_LABEL_ADD_WITH_DOTS);
        this.addButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addButton.addSelectionListener((SelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.addButton, "org.eclipse.wst.xsd.ui.xsdud0150");
        this.removeButton = new Button(buttonComposite, 8);
        this.removeButton.setText(Messages._UI_LABEL_DELETE);
        this.removeButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.removeButton.addSelectionListener((SelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.removeButton, "org.eclipse.wst.xsd.ui.xsdud0160");
        this.editButton = new Button(buttonComposite, 8);
        this.editButton.setText(Messages._UI_LABEL_EDIT);
        this.editButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.editButton.addSelectionListener((SelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.editButton, "org.eclipse.wst.xsd.ui.xsdud0170");
        List initialSelection = this.getInitialElementSelections();
        if (initialSelection != null) {
            this.categoryTableViewer.setSelection((ISelection)new StructuredSelection(initialSelection));
        }
        Label elementLabel = new Label(categoryComposite, 16384);
        elementLabel.setText(Messages._UI_LABEL_AVAILABLE_COMPONENTS_TO_ADD);
        new Label(categoryComposite, 0);
        this.elementTableViewer = new TableViewer(categoryComposite, this.getTableStyle());
        this.elementTableViewer.setContentProvider((IContentProvider)new ElementContentProvider());
        this.elementTableViewer.setLabelProvider((IBaseLabelProvider)new ElementLabelProvider());
        this.elementTableViewer.setInput(null);
        this.elementTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AddExtensionsComponentDialog.this.okPressed();
            }
        });
        if (this.elementTableViewerFilter != null) {
            this.elementTableViewer.addFilter(this.elementTableViewerFilter);
        }
        gd = new GridData(1808);
        table = this.elementTableViewer.getTable();
        table.setLayoutData((Object)gd);
        table.setFont(container.getFont());
        this.elementTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddExtensionsComponentDialog.this.getButton(0).setEnabled(true);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.elementTableViewer.getControl(), "org.eclipse.wst.xsd.ui.xsdud0140");
        return parent;
    }

    public void create() {
        super.create();
        if (this.categoryTableViewer.getTable().getItemCount() > 0) {
            this.categoryTableViewer.getTable().select(0);
            StructuredSelection structuredSelection = this.currentExtCategory != null ? new StructuredSelection((Object)this.currentExtCategory) : new StructuredSelection(this.categoryTableViewer.getElementAt(0));
            this.categoryTableViewer.setSelection((ISelection)structuredSelection);
        }
        this.existingNames = new ArrayList();
        TableItem[] categories = this.categoryTableViewer.getTable().getItems();
        int i = 0;
        while (i < categories.length) {
            this.existingNames.add(categories[i].getText());
            SpecificationForExtensionsSchema spec = (SpecificationForExtensionsSchema)categories[i].getData();
            XSDSchema schema = AddExtensionsComponentDialog.getASISchemaModel(spec);
            if (schema != null) {
                List components = AddExtensionsComponentDialog.buildInput(schema);
                this.specToComponentsList.put(spec, components);
                Object[] remains = components.toArray();
                if (this.elementTableViewerFilter != null) {
                    remains = this.elementTableViewerFilter.filter((Viewer)this.elementTableViewer, (Object)this.elementTableViewer.getTable(), remains);
                }
                if (remains.length == 0) {
                    categories[i].setForeground(this.getShell().getDisplay().getSystemColor(15));
                }
            }
            ++i;
        }
        this.getButton(0).setEnabled(false);
    }

    public void addElementsTableFilter(ViewerFilter filter) {
        this.elementTableViewerFilter = filter;
    }

    public void setPrefStore(IPreferenceStore prefStore) {
        this.prefStore = prefStore;
    }

    protected Point getInitialSize() {
        return this.getShell().computeSize(400, 300);
    }

    protected int getTableStyle() {
        return 2820;
    }

    protected void okPressed() {
        this.getShell().setCursor(new Cursor((Device)this.getShell().getDisplay(), 1));
        IStructuredSelection elementSelection = (IStructuredSelection)this.elementTableViewer.getSelection();
        IStructuredSelection categorySelection = (IStructuredSelection)this.categoryTableViewer.getSelection();
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(elementSelection.getFirstElement());
        result.add(categorySelection.getFirstElement());
        if (elementSelection.getFirstElement() != null) {
            this.setResult(result);
        } else {
            this.setResult(null);
        }
        super.okPressed();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.addButton) {
            AddNewCategoryDialog addNewCategoryDialog = new AddNewCategoryDialog(this.getShell());
            addNewCategoryDialog.setUnavailableCategoryNames(this.existingNames);
            if (addNewCategoryDialog.open() == 0) {
                SpecificationForExtensionsSchema schemaSpec = new SpecificationForExtensionsSchema();
                schemaSpec.setDisplayName(addNewCategoryDialog.getNewCategoryName());
                schemaSpec.setLocation(addNewCategoryDialog.getCategoryLocation());
                schemaSpec.setSourceHint(addNewCategoryDialog.getSource());
                schemaSpec.setFromCatalog(addNewCategoryDialog.getFromCatalog());
                this.fInput.add(schemaSpec);
                this.existingNames.add(schemaSpec.getDisplayName());
                this.categoryTableViewer.refresh(false);
                this.categoryTableViewer.setSelection((ISelection)new StructuredSelection((Object)schemaSpec));
                this.getButton(0).setEnabled(false);
                this.storeSpecInPref(schemaSpec);
            }
        } else if (e.widget == this.removeButton) {
            TableItem[] selections = this.categoryTableViewer.getTable().getSelection();
            int i = 0;
            while (i < selections.length) {
                SpecificationForExtensionsSchema spec = (SpecificationForExtensionsSchema)selections[i].getData();
                this.fInput.remove(spec);
                this.existingNames.remove(spec.getDisplayName());
                this.specToComponentsList.remove(spec);
                this.removeFromPref(spec);
                ++i;
            }
            this.categoryTableViewer.refresh(false);
            this.elementTableViewer.setInput(null);
            this.elementTableViewer.refresh();
            this.getButton(0).setEnabled(false);
        } else if (e.widget == this.editButton) {
            AddNewCategoryDialog dialog = new AddNewCategoryDialog(this.getShell(), Messages._UI_LABEL_EDIT_CATEGORY);
            TableItem[] selections = this.categoryTableViewer.getTable().getSelection();
            if (selections.length == 0) {
                return;
            }
            SpecificationForExtensionsSchema spec = (SpecificationForExtensionsSchema)selections[0].getData();
            String displayName = spec.getDisplayName();
            dialog.setCategoryName(displayName);
            dialog.setFromCatalog(spec.isFromCatalog());
            dialog.setSource(spec.getSourceHint());
            dialog.setCategoryLocation(spec.getLocation());
            this.specToComponentsList.remove(spec);
            dialog.setUnavailableCategoryNames(this.existingNames);
            if (dialog.open() == 0) {
                this.existingNames.remove(displayName);
                String newDisplayName = dialog.getNewCategoryName();
                spec.setDisplayName(newDisplayName);
                spec.setLocation(dialog.getCategoryLocation());
                spec.setSourceHint(dialog.getSource());
                spec.setFromCatalog(dialog.getFromCatalog());
                spec.setNamespaceURI(null);
                this.existingNames.add(newDisplayName);
                this.categoryTableViewer.update((Object)spec, null);
                this.refreshElementsViewer(spec);
                this.editSpecInPref(displayName, spec);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object obj;
        ISelection selection;
        if (event.getSource() == this.categoryTableViewer && (selection = event.getSelection()) instanceof StructuredSelection && (obj = ((StructuredSelection)selection).getFirstElement()) instanceof SpecificationForExtensionsSchema) {
            SpecificationForExtensionsSchema spec;
            this.currentExtCategory = spec = (SpecificationForExtensionsSchema)obj;
            this.refreshElementsViewer(spec);
            if (spec.isDefautSchema()) {
                this.editButton.setEnabled(false);
                this.removeButton.setEnabled(false);
            } else {
                this.editButton.setEnabled(true);
                this.removeButton.setEnabled(true);
            }
            this.getButton(0).setEnabled(false);
        }
    }

    private void refreshElementsViewer(SpecificationForExtensionsSchema spec) {
        List components = (List)this.specToComponentsList.get(spec);
        if (components != null) {
            this.elementTableViewer.setInput((Object)components);
            return;
        }
        XSDSchema xsdSchema = AddExtensionsComponentDialog.getASISchemaModel(spec);
        if (xsdSchema == null) {
            MessageBox errDialog = new MessageBox(this.getShell(), 1);
            errDialog.setText(Messages._UI_ERROR_INVALID_CATEGORY);
            errDialog.setMessage(String.valueOf(Messages._UI_LABEL_EXTENSION_CATEGORIES) + " " + spec.getDisplayName() + "\n" + Messages._UI_ERROR_FILE_CANNOT_BE_PARSED + "\n" + Messages._UI_ERROR_VALIDATE_THE_FILE);
            errDialog.open();
            this.elementTableViewer.setInput(new ArrayList(0));
            return;
        }
        components = AddExtensionsComponentDialog.buildInput(xsdSchema);
        this.specToComponentsList.put(spec, components);
        List allItems = AddExtensionsComponentDialog.buildInput(xsdSchema);
        if (allItems == null) {
            return;
        }
        this.elementTableViewer.setInput((Object)allItems);
    }

    private static List buildInput(XSDSchema xsdSchema) {
        if (xsdSchema == null) {
            return null;
        }
        EList elements = xsdSchema.getElementDeclarations();
        EList attributes = xsdSchema.getAttributeDeclarations();
        String targetNamespace = xsdSchema.getTargetNamespace();
        ArrayList<Object> allItems = new ArrayList<Object>(attributes.size() + elements.size());
        int i = 0;
        while (i < elements.size()) {
            XSDElementDeclaration currentElement = (XSDElementDeclaration)elements.get(i);
            if (currentElement.getTargetNamespace() != null) {
                if (currentElement.getTargetNamespace().equals(targetNamespace)) {
                    allItems.add(currentElement);
                }
            } else if (targetNamespace == null) {
                allItems.add(currentElement);
            }
            ++i;
        }
        i = 0;
        while (i < attributes.size()) {
            XSDAttributeDeclaration currentAttribute = (XSDAttributeDeclaration)attributes.get(i);
            if (currentAttribute.getTargetNamespace() != null) {
                if (currentAttribute.isGlobal() && currentAttribute.getTargetNamespace().equals(targetNamespace)) {
                    allItems.add(currentAttribute);
                }
            } else if (targetNamespace == null) {
                allItems.add(currentAttribute);
            }
            ++i;
        }
        return allItems;
    }

    private static XSDSchema getASISchemaModel(SpecificationForExtensionsSchema extensionsSchemaSpec) {
        String location = extensionsSchemaSpec.getLocation();
        if (location == null) {
            return null;
        }
        XSDSchema xsdSchema = XSDImpl.buildXSDModel((String)location);
        if (extensionsSchemaSpec.getNamespaceURI() == null) {
            extensionsSchemaSpec.setNamespaceURI(xsdSchema.getTargetNamespace());
        }
        return xsdSchema;
    }

    private void storeSpecInPref(SpecificationForExtensionsSchema schemaSpec) {
        if (this.prefStore == null) {
            return;
        }
        String currentValue = this.prefStore.getString("USER-ADDED-EXT-SCHEMAS");
        String specDesc = "  \t" + schemaSpec.getDisplayName() + "\t" + schemaSpec.getNamespaceURI() + "\t" + schemaSpec.getLocation() + "\t" + schemaSpec.isDefautSchema() + "\t" + schemaSpec.getSourceHint() + "\t" + schemaSpec.isFromCatalog();
        currentValue = String.valueOf(currentValue) + specDesc + "\n";
        this.prefStore.setValue("USER-ADDED-EXT-SCHEMAS", currentValue);
    }

    private void editSpecInPref(String displayName, SpecificationForExtensionsSchema newSpec) {
        if (this.prefStore == null) {
            return;
        }
        String newValue = "";
        String currentValue = this.prefStore.getString("USER-ADDED-EXT-SCHEMAS");
        StringTokenizer tokenizer = new StringTokenizer(currentValue, "\n");
        while (tokenizer.hasMoreTokens()) {
            String oneSpecDesc = tokenizer.nextToken();
            StringTokenizer _tokenizer_2 = new StringTokenizer(oneSpecDesc, "\t");
            _tokenizer_2.nextToken();
            String dName = _tokenizer_2.nextToken();
            if (dName.equals(displayName)) {
                oneSpecDesc = "  \t" + newSpec.getDisplayName() + "\t" + newSpec.getNamespaceURI() + "\t" + newSpec.getLocation() + "\t" + newSpec.isDefautSchema() + "\t" + newSpec.getSourceHint() + "\t" + newSpec.isFromCatalog();
            }
            newValue = String.valueOf(newValue) + oneSpecDesc + "\n";
        }
        this.prefStore.setValue("USER-ADDED-EXT-SCHEMAS", newValue);
    }

    private void removeFromPref(SpecificationForExtensionsSchema spec) {
        if (this.prefStore == null) {
            return;
        }
        String newValue = "";
        String currentValue = this.prefStore.getString("USER-ADDED-EXT-SCHEMAS");
        StringTokenizer tokenizer = new StringTokenizer(currentValue, "\n");
        while (tokenizer.hasMoreTokens()) {
            String oneSpecDesc = tokenizer.nextToken();
            StringTokenizer _tokenizer_2 = new StringTokenizer(oneSpecDesc, "\t");
            _tokenizer_2.nextToken();
            String dName = _tokenizer_2.nextToken();
            if (dName.equals(spec.getDisplayName())) continue;
            newValue = String.valueOf(newValue) + oneSpecDesc + "\n";
        }
        this.prefStore.setValue("USER-ADDED-EXT-SCHEMAS", newValue);
    }

    public boolean close() {
        return super.close();
    }

    protected void enableButtons(boolean value) {
        this.editButton.setEnabled(value);
        this.addButton.setEnabled(value);
        this.removeButton.setEnabled(value);
    }

    static class CategoryContentProvider
    implements IStructuredContentProvider {
        CategoryContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            SpecificationForExtensionsSchema[] extensionsSchemaSpecs = null;
            try {
                List inputList = (List)inputElement;
                extensionsSchemaSpecs = inputList.toArray(new SpecificationForExtensionsSchema[0]);
            }
            catch (Exception exception) {}
            return extensionsSchemaSpecs;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    static class CategoryLabelProvider
    extends LabelProvider {
        CategoryLabelProvider() {
        }

        public Image getImage(Object element) {
            return XSDEditorPlugin.getXSDImage("icons/appinfo_category.gif");
        }

        public String getText(Object element) {
            if (element instanceof SpecificationForExtensionsSchema) {
                return ((SpecificationForExtensionsSchema)element).getDisplayName();
            }
            return super.getText(element);
        }
    }

    static class ElementContentProvider
    implements IStructuredContentProvider {
        ElementContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ElementLabelProvider
    extends LabelProvider {
        ElementLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof XSDElementDeclaration) {
                Image img;
                String namespace = ((XSDElementDeclaration)element).getSchema().getTargetNamespace();
                String name = ((XSDElementDeclaration)element).getName();
                Element tempElement = tempDoc.createElementNS(namespace, name);
                ILabelProvider lp = XSDEditorPlugin.getDefault().getNodeCustomizationRegistry().getLabelProvider(namespace);
                if (lp != null && (img = lp.getImage((Object)tempElement)) != null) {
                    return img;
                }
                return DEFAULT_ELEMENT_ICON;
            }
            if (element instanceof XSDAttributeDeclaration) {
                return DEFAULT_ATTRIBUTE_ICON;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof XSDElementDeclaration) {
                return ((XSDElementDeclaration)element).getName();
            }
            if (element instanceof XSDAttributeDeclaration) {
                return ((XSDAttributeDeclaration)element).getName();
            }
            return super.getText(element);
        }
    }
}

