/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.model;

import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.model.ModelLifecycleEvent;
import org.eclipse.wst.sse.core.internal.provisional.IModelLifecycleListener;
import org.eclipse.wst.sse.core.internal.util.Utilities;

class LifecycleNotificationManager {
    private Object[] fListeners;

    LifecycleNotificationManager() {
    }

    void addListener(IModelLifecycleListener listener) {
        if (Logger.DEBUG && Utilities.contains(this.fListeners, listener)) {
            Logger.log(2, "IModelLifecycleListener " + listener + " listening more than once");
        }
        int oldSize = 0;
        if (this.fListeners != null) {
            oldSize = this.fListeners.length;
        }
        int newSize = oldSize + 1;
        Object[] newListeners = new Object[newSize];
        if (this.fListeners != null) {
            System.arraycopy(this.fListeners, 0, newListeners, 0, oldSize);
        }
        newListeners[newSize - 1] = listener;
        this.fListeners = newListeners;
    }

    void removeListener(IModelLifecycleListener listener) {
        if (Utilities.contains(this.fListeners, listener)) {
            int oldSize = this.fListeners.length;
            int newSize = oldSize - 1;
            Object[] newListeners = new Object[newSize];
            int index = 0;
            boolean removedOnce = false;
            int i = 0;
            while (i < oldSize) {
                if (this.fListeners[i] == listener && !removedOnce) {
                    removedOnce = true;
                } else {
                    newListeners[index++] = this.fListeners[i];
                }
                ++i;
            }
            this.fListeners = newListeners;
        }
        if (Logger.DEBUG && Utilities.contains(this.fListeners, listener)) {
            Logger.log(2, "IModelLifecycleListener " + listener + " removed once but still listening");
        }
    }

    void signalLifecycleEvent(ModelLifecycleEvent event) {
        if (Logger.DEBUG_LIFECYCLE) {
            Logger.log(1, "ModelLifecycleEvent fired for " + event.getModel().getId() + ": " + event.toString());
            System.out.println("ModelLifecycleEvent fired for " + event.getModel().getId() + ": " + event.toString());
        }
        if (this.fListeners != null) {
            Object[] holdListeners = this.fListeners;
            int i = 0;
            while (i < holdListeners.length) {
                IModelLifecycleListener listener = (IModelLifecycleListener)holdListeners[i];
                if ((event.getInternalType() & 0x100) == 256) {
                    listener.processPreModelEvent(event);
                }
                if ((event.getInternalType() & 0x200) == 512) {
                    listener.processPostModelEvent(event);
                }
                ++i;
            }
        }
    }
}

