/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.util.widget;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.i18n.CoreMessages;
import org.eclipse.buildship.core.internal.util.gradle.GradleVersion;
import org.eclipse.buildship.core.internal.util.gradle.PublishedGradleVersionsWrapper;
import org.eclipse.buildship.ui.internal.i18n.UiMessages;
import org.eclipse.buildship.ui.internal.util.file.DirectoryDialogSelectionListener;
import org.eclipse.buildship.ui.internal.util.gradle.GradleDistributionViewModel;
import org.eclipse.buildship.ui.internal.util.widget.HoverText;
import org.eclipse.buildship.ui.internal.util.widget.UiBuilder;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public final class GradleDistributionGroup
extends Group {
    private final List<DistributionChangedListener> listeners;
    private final PublishedGradleVersionsWrapper publishedGradleVersions;
    private Text localInstallationDirText;
    private Button localInstallationDirBrowseButton;
    private Label localInstallationWarningLabel;
    private Text remoteDistributionUriText;
    private Combo gradleVersionCombo;
    private Button useGradleWrapperOption;
    private Button useLocalInstallationDirOption;
    private Button useRemoteDistributionUriOption;
    private Button useGradleVersionOption;

    public GradleDistributionGroup(PublishedGradleVersionsWrapper publishedGradleVersions, Composite parent) {
        super(parent, 0);
        this.setText(CoreMessages.GradleDistribution_Label_Group);
        this.listeners = new LinkedList<DistributionChangedListener>();
        this.publishedGradleVersions = publishedGradleVersions;
        this.createWidgets();
        this.updateEnablement();
        this.addListeners();
    }

    private void createWidgets() {
        this.setLayoutData(new GridData(4, 128, true, false));
        GridLayoutFactory.swtDefaults().numColumns(4).applyTo((Composite)this);
        UiBuilder.UiBuilderFactory uiBuilder = new UiBuilder.UiBuilderFactory(JFaceResources.getDialogFont());
        this.useGradleWrapperOption = uiBuilder.newRadio((Composite)this).alignLeft(4).text(CoreMessages.GradleDistribution_Label_GradleWrapper).control();
        this.useLocalInstallationDirOption = uiBuilder.newRadio((Composite)this).alignLeft().text(CoreMessages.GradleDistribution_Label_LocalInstallationDirectory).control();
        this.localInstallationDirText = uiBuilder.newText((Composite)this).alignFillHorizontal().disabled().control();
        this.localInstallationDirBrowseButton = uiBuilder.newButton((Composite)this).alignLeft().disabled().text(UiMessages.Button_Label_Browse).control();
        this.localInstallationDirBrowseButton.addSelectionListener((SelectionListener)new DirectoryDialogSelectionListener(this.getShell(), this.localInstallationDirText, CoreMessages.GradleDistribution_Label_LocalInstallationDirectory));
        this.localInstallationWarningLabel = uiBuilder.newLabel((Composite)this).alignRight().control();
        this.localInstallationWarningLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        HoverText.createAndAttach((Control)this.localInstallationWarningLabel, NLS.bind((String)CoreMessages.WarningMessage_Using_0_NonPortable, (Object)"local Gradle distribution"));
        this.useRemoteDistributionUriOption = uiBuilder.newRadio((Composite)this).alignLeft().text(CoreMessages.GradleDistribution_Label_RemoteDistributionUri).control();
        this.remoteDistributionUriText = uiBuilder.newText((Composite)this).alignFillHorizontal().disabled().control();
        uiBuilder.span((Composite)this);
        uiBuilder.span((Composite)this);
        this.useGradleVersionOption = uiBuilder.newRadio((Composite)this).alignLeft().text(CoreMessages.GradleDistribution_Label_SpecificGradleVersion).control();
        this.gradleVersionCombo = uiBuilder.newCombo((Composite)this).alignFillHorizontal().disabled().control();
        this.gradleVersionCombo.setSize(150, this.gradleVersionCombo.getSize().y);
        this.gradleVersionCombo.setItems(this.getGradleVersions());
        if (this.gradleVersionCombo.getItemCount() > 0) {
            this.gradleVersionCombo.select(0);
        }
        uiBuilder.span((Composite)this);
        uiBuilder.span((Composite)this);
    }

    private void updateEnablement() {
        boolean groupEnabled = this.getEnabled();
        this.useGradleWrapperOption.setEnabled(groupEnabled);
        this.useLocalInstallationDirOption.setEnabled(groupEnabled);
        this.useRemoteDistributionUriOption.setEnabled(groupEnabled);
        this.useGradleVersionOption.setEnabled(groupEnabled);
        this.localInstallationDirText.setEnabled(groupEnabled && this.useLocalInstallationDirOption.getSelection());
        this.localInstallationDirBrowseButton.setEnabled(groupEnabled && this.useLocalInstallationDirOption.getSelection());
        this.remoteDistributionUriText.setEnabled(groupEnabled && this.useRemoteDistributionUriOption.getSelection());
        this.gradleVersionCombo.setEnabled(groupEnabled && this.useGradleVersionOption.getSelection());
        this.updateWarningVisibility();
    }

    private void updateWarningVisibility() {
        boolean warningShouldBeVisible;
        boolean warningIsVisible = this.localInstallationWarningLabel.getVisible();
        boolean bl = warningShouldBeVisible = this.getEnabled() && this.useLocalInstallationDirOption.getSelection();
        if (warningIsVisible != warningShouldBeVisible) {
            this.localInstallationWarningLabel.setVisible(warningShouldBeVisible);
            Object layoutData = this.localInstallationWarningLabel.getLayoutData();
            if (layoutData instanceof GridData) {
                GridData gridData = (GridData)layoutData;
                gridData.widthHint = warningShouldBeVisible ? -1 : 0;
                this.compatRequestLayout();
            }
        }
    }

    private void compatRequestLayout() {
        this.getShell().layout(new Control[]{this}, 4);
    }

    public GradleDistributionViewModel getDistribution() {
        if (this.useGradleWrapperOption.getSelection()) {
            return new GradleDistributionViewModel(GradleDistributionViewModel.Type.WRAPPER, "");
        }
        if (this.useLocalInstallationDirOption.getSelection()) {
            return new GradleDistributionViewModel(GradleDistributionViewModel.Type.LOCAL_INSTALLATION, this.localInstallationDirText.getText());
        }
        if (this.useRemoteDistributionUriOption.getSelection()) {
            return new GradleDistributionViewModel(GradleDistributionViewModel.Type.REMOTE_DISTRIBUTION, this.remoteDistributionUriText.getText());
        }
        if (this.useGradleVersionOption.getSelection()) {
            return new GradleDistributionViewModel(GradleDistributionViewModel.Type.VERSION, this.getSpecificVersion());
        }
        throw new GradlePluginsRuntimeException("No Gradle distribution type selected");
    }

    private String getSpecificVersion() {
        int selectionIndex = this.gradleVersionCombo.getSelectionIndex();
        return Strings.emptyToNull((String)(selectionIndex == -1 || !Strings.isNullOrEmpty((String)this.gradleVersionCombo.getText()) ? this.gradleVersionCombo.getText() : this.gradleVersionCombo.getItem(selectionIndex)));
    }

    public void setDistribution(GradleDistributionViewModel distribution) {
        GradleDistributionViewModel.Type type = distribution.getType().get();
        String configuration = Strings.nullToEmpty((String)distribution.getConfiguration());
        ImmutableList allRadios = ImmutableList.of((Object)this.useGradleWrapperOption, (Object)this.useLocalInstallationDirOption, (Object)this.useRemoteDistributionUriOption, (Object)this.useGradleVersionOption);
        switch (type) {
            case WRAPPER: {
                this.updateSelectedState(this.useGradleWrapperOption, (List<Button>)allRadios);
                break;
            }
            case LOCAL_INSTALLATION: {
                this.updateSelectedState(this.useLocalInstallationDirOption, (List<Button>)allRadios);
                this.localInstallationDirText.setText(configuration);
                break;
            }
            case REMOTE_DISTRIBUTION: {
                this.updateSelectedState(this.useRemoteDistributionUriOption, (List<Button>)allRadios);
                this.remoteDistributionUriText.setText(configuration);
                break;
            }
            case VERSION: {
                this.updateSelectedState(this.useGradleVersionOption, (List<Button>)allRadios);
                this.updateVersionSelection(configuration);
                break;
            }
            default: {
                throw new GradlePluginsRuntimeException("Unrecognized Gradle distribution type: " + type);
            }
        }
        this.updateEnablement();
    }

    private String[] getGradleVersions() {
        return (String[])FluentIterable.from((Iterable)this.publishedGradleVersions.getVersions()).transform((Function)new Function<GradleVersion, String>(){

            public String apply(GradleVersion gradleVersion) {
                return gradleVersion.getVersion();
            }
        }).toArray(String.class);
    }

    private void updateSelectedState(Button selectedRadioButton, List<Button> allRadioButtons) {
        for (Button radioButton : allRadioButtons) {
            if (radioButton.equals(selectedRadioButton)) {
                radioButton.setSelection(true);
                radioButton.setFocus();
                continue;
            }
            radioButton.setSelection(false);
        }
    }

    private void updateVersionSelection(String version) {
        for (int i = 0; i < this.gradleVersionCombo.getItemCount(); ++i) {
            if (!this.gradleVersionCombo.getItem(i).equals(version)) continue;
            this.gradleVersionCombo.select(i);
            return;
        }
        int index = this.gradleVersionCombo.getItemCount();
        this.gradleVersionCombo.add(version, index);
        this.gradleVersionCombo.select(index);
    }

    private void addListeners() {
        NotifyingListener listener = new NotifyingListener();
        this.localInstallationDirText.addModifyListener((ModifyListener)listener);
        this.remoteDistributionUriText.addModifyListener((ModifyListener)listener);
        this.gradleVersionCombo.addModifyListener((ModifyListener)listener);
        this.gradleVersionCombo.addSelectionListener((SelectionListener)listener);
        this.useGradleWrapperOption.addSelectionListener((SelectionListener)listener);
        this.useLocalInstallationDirOption.addSelectionListener((SelectionListener)listener);
        this.useRemoteDistributionUriOption.addSelectionListener((SelectionListener)listener);
        this.useGradleVersionOption.addSelectionListener((SelectionListener)listener);
        this.localInstallationDirText.addModifyListener(l -> this.updateWarningVisibility());
    }

    public void addDistributionChangedListener(DistributionChangedListener listener) {
        this.listeners.add(listener);
    }

    protected void checkSubclass() {
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateEnablement();
    }

    private final class NotifyingListener
    extends SelectionAdapter
    implements ModifyListener {
        private NotifyingListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.updateAndNotify();
        }

        public void modifyText(ModifyEvent e) {
            this.updateAndNotify();
        }

        private void updateAndNotify() {
            GradleDistributionGroup.this.updateEnablement();
            for (DistributionChangedListener listener : GradleDistributionGroup.this.listeners) {
                listener.distributionUpdated(GradleDistributionGroup.this.getDistribution());
            }
        }
    }

    public static interface DistributionChangedListener {
        public void distributionUpdated(GradleDistributionViewModel var1);
    }
}

