/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.gnu.IInclude;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.editor.MakefileEditor;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;

public class OpenIncludeAction
extends Action {
    ISelectionProvider fSelectionProvider;

    public OpenIncludeAction(ISelectionProvider provider) {
        super(MakeUIPlugin.getResourceString("OpenIncludeAction.title"));
        this.setDescription(MakeUIPlugin.getResourceString("OpenIncludeAction.description"));
        this.setToolTipText(MakeUIPlugin.getResourceString("OpenIncludeAction.tooltip"));
        this.fSelectionProvider = provider;
    }

    public void run() {
        IInclude[] includes = this.getIncludeDirective(this.fSelectionProvider.getSelection());
        if (includes != null) {
            IInclude[] iIncludeArray = includes;
            int n = includes.length;
            int n2 = 0;
            while (n2 < n) {
                IInclude include = iIncludeArray[n2];
                IDirective[] iDirectiveArray = include.getDirectives();
                int n3 = iDirectiveArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IDirective directive = iDirectiveArray[n4];
                    try {
                        OpenIncludeAction.openInEditor(directive);
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public static IEditorPart openInEditor(IDirective directive) throws PartInitException {
        try {
            URI uri = directive.getMakefile().getFileURI();
            IFileStore store = EFS.getStore((URI)uri);
            IFile[] file = MakeUIPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
            if (file.length > 0 && file[0] != null) {
                IWorkbenchPage p = MakeUIPlugin.getActivePage();
                if (p != null) {
                    IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IFile)file[0], (boolean)true);
                    if (editorPart instanceof MakefileEditor) {
                        ((MakefileEditor)editorPart).setSelection(directive, true);
                    }
                    return editorPart;
                }
            } else {
                FileStoreEditorInput input = new FileStoreEditorInput(store);
                IWorkbenchPage p = MakeUIPlugin.getActivePage();
                if (p != null) {
                    String editorID = "org.eclipse.cdt.make.editor";
                    IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IEditorInput)input, (String)editorID, (boolean)true);
                    if (editorPart instanceof MakefileEditor) {
                        ((MakefileEditor)editorPart).setSelection(directive, true);
                    }
                    return editorPart;
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    IInclude[] getIncludeDirective(ISelection sel) {
        List list;
        if (!sel.isEmpty() && sel instanceof IStructuredSelection && (list = ((IStructuredSelection)sel).toList()).size() > 0) {
            ArrayList<IInclude> includes = new ArrayList<IInclude>(list.size());
            for (Object element : list) {
                if (!(element instanceof IInclude)) continue;
                includes.add((IInclude)element);
            }
            return includes.toArray(new IInclude[includes.size()]);
        }
        return null;
    }

    public boolean canActionBeAdded(ISelection selection) {
        IInclude[] includes = this.getIncludeDirective(selection);
        return includes != null && includes.length != 0;
    }
}

