/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.actions;

import java.util.HashSet;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SteppingController;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.commands.IDebugCommandRequest;

@Immutable
public abstract class DsfCommandRunnable
extends DsfRunnable {
    private final IRunControl.IExecutionDMContext[] fContexts;
    private final DsfServicesTracker fTracker;
    private final IDebugCommandRequest fRequest;

    public IRunControl.IExecutionDMContext getContext() {
        return this.fContexts != null && this.fContexts.length > 0 ? this.fContexts[0] : null;
    }

    public IRunControl.IExecutionDMContext[] getContexts() {
        return this.fContexts;
    }

    public IRunControl getRunControl() {
        return (IRunControl)this.fTracker.getService(IRunControl.class);
    }

    public SteppingController getSteppingController() {
        if (this.fContexts != null && this.fContexts.length > 0) {
            return (SteppingController)this.fContexts[0].getAdapter(SteppingController.class);
        }
        return null;
    }

    public IProcesses getProcessService() {
        return (IProcesses)this.fTracker.getService(IProcesses.class);
    }

    public DsfCommandRunnable(DsfServicesTracker servicesTracker, Object element, IDebugCommandRequest request) {
        this(servicesTracker, new Object[]{element}, request);
    }

    public DsfCommandRunnable(DsfServicesTracker servicesTracker, Object[] elements, IDebugCommandRequest request) {
        this.fTracker = servicesTracker;
        this.fRequest = request;
        HashSet<IRunControl.IExecutionDMContext> execDmcSet = new HashSet<IRunControl.IExecutionDMContext>(request.getElements().length);
        Object[] objectArray = request.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDMVMContext vmc;
            IRunControl.IExecutionDMContext execDmc;
            Object element = objectArray[n2];
            if (element instanceof IDMVMContext && (execDmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)(vmc = (IDMVMContext)element).getDMContext(), IRunControl.IExecutionDMContext.class)) != null) {
                execDmcSet.add(execDmc);
            }
            ++n2;
        }
        this.fContexts = execDmcSet.size() == 0 ? null : execDmcSet.toArray(new IRunControl.IExecutionDMContext[execDmcSet.size()]);
    }

    public final void run() {
        if (this.fRequest.isCanceled()) {
            this.fRequest.done();
            return;
        }
        if (this.getContexts() == null || this.getContexts().length == 0) {
            this.fRequest.setStatus(this.makeError("Selected objects do not support run control.", null));
        } else if (this.getRunControl() == null || this.getSteppingController() == null) {
            this.fRequest.setStatus(this.makeError("Run Control not available", null));
        } else {
            this.doExecute();
        }
        this.fRequest.done();
    }

    protected abstract void doExecute();

    protected IStatus makeError(String message, Throwable e) {
        return new Status(4, "org.eclipse.cdt.dsf.ui", -1, message, e);
    }
}

