/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.variables;

import org.eclipse.core.internal.variables.StringVariable;
import org.eclipse.core.internal.variables.StringVariableManager;
import org.eclipse.core.internal.variables.VariablesMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.IValueVariableInitializer;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;

public class ContributedValueVariable
extends StringVariable
implements IValueVariable {
    private String fValue;
    private boolean fInitialized = false;
    private final boolean fReadOnly;

    public ContributedValueVariable(String name, String description, boolean readOnly, IConfigurationElement configurationElement) {
        super(name, description, configurationElement);
        this.fReadOnly = readOnly;
    }

    @Override
    public void setValue(String value) {
        if (!this.isReadOnly() || !this.isInitialized()) {
            this.fValue = value;
            this.setInitialized(true);
            StringVariableManager.getDefault().notifyChanged(this);
        }
    }

    @Override
    public String getValue() {
        if (!this.isInitialized()) {
            this.initialize();
        }
        return this.fValue;
    }

    private void initialize() {
        block7: {
            if (this.getConfigurationElement() != null) {
                String value = this.getConfigurationElement().getAttribute("initialValue");
                if (value == null) {
                    String className = this.getConfigurationElement().getAttribute("initializerClass");
                    if (className != null) {
                        try {
                            Object object = this.getConfigurationElement().createExecutableExtension("initializerClass");
                            if (object instanceof IValueVariableInitializer) {
                                IValueVariableInitializer initializer = (IValueVariableInitializer)object;
                                initializer.initialize(this);
                                break block7;
                            }
                            VariablesPlugin.logMessage(NLS.bind((String)VariablesMessages.VarInitFailDueNonIValueVariable, (Object)this.getName()), null);
                        }
                        catch (CoreException e) {
                            VariablesPlugin.logMessage(NLS.bind((String)VariablesMessages.VarInitFail, (Object)this.getName()), e);
                        }
                    }
                } else {
                    this.setValue(value);
                }
            }
        }
        this.setInitialized(true);
    }

    protected boolean isInitialized() {
        return this.fInitialized;
    }

    protected void setInitialized(boolean initialized) {
        this.fInitialized = initialized;
    }

    @Override
    public boolean isReadOnly() {
        return this.fReadOnly;
    }

    @Override
    public boolean isContributed() {
        return this.getConfigurationElement() != null;
    }
}

