/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.core.parser.scanner.AbstractCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.StreamHasher;

public abstract class LazyCharArray
extends AbstractCharArray {
    private static final int CHUNK_BITS = 16;
    public static final int CHUNK_SIZE = 65536;
    private int fLength = -1;
    private List<Chunk> fChunks = new ArrayList<Chunk>();
    private StreamHasher fHasher = new StreamHasher();
    private long fHash64;
    private char[] fCurrentChars;

    protected LazyCharArray() {
    }

    @Override
    public final int tryGetLength() {
        return this.fLength;
    }

    @Override
    public final int getLength() {
        this.readAllChunks();
        return this.fLength;
    }

    @Override
    public final boolean isValidOffset(int offset) {
        if (offset < 0) {
            return false;
        }
        if (this.fLength >= 0) {
            return offset < this.fLength;
        }
        return this.getChunkForOffset(offset) != null;
    }

    @Override
    public long getContentsHash() {
        if (this.fHasher != null) {
            this.readAllChunks();
            this.fHash64 = this.fHasher.computeHash();
            this.fHasher = null;
        }
        return this.fHash64;
    }

    @Override
    public final char get(int offset) {
        Chunk chunk = this.getChunkForOffset(offset);
        if (chunk != null) {
            return this.getChunkData(chunk)[offset - chunk.fCharOffset];
        }
        return '\u0000';
    }

    @Override
    public final void arraycopy(int offset, char[] destination, int destinationPos, int length) {
        Chunk chunk = this.getChunkForOffset(offset);
        int offsetInChunk = offset - chunk.fCharOffset;
        char[] data = this.getChunkData(chunk);
        int maxLenInChunk = data.length - offsetInChunk;
        if (length <= maxLenInChunk) {
            System.arraycopy(data, offsetInChunk, destination, destinationPos, length);
        } else {
            System.arraycopy(data, offsetInChunk, destination, destinationPos, maxLenInChunk);
            this.arraycopy(offset + maxLenInChunk, destination, destinationPos + maxLenInChunk, length - maxLenInChunk);
        }
    }

    private void readAllChunks() {
        if (this.fLength < 0) {
            this.getChunkForOffset(Integer.MAX_VALUE);
        }
    }

    private Chunk getChunkForOffset(int offset) {
        int minChunkNumber = offset >> 16;
        Chunk chunk;
        while ((chunk = this.getChunkByNumber(minChunkNumber)) != null) {
            if (offset < chunk.fCharEndOffset) {
                return chunk;
            }
            ++minChunkNumber;
        }
        return null;
    }

    private Chunk getChunkByNumber(int chunkNumber) {
        int chunkCount = this.fChunks.size();
        if (chunkNumber < chunkCount) {
            return this.fChunks.get(chunkNumber);
        }
        if (this.fLength >= 0) {
            return null;
        }
        return this.createChunk(chunkNumber);
    }

    protected Chunk createChunk(int chunkNumber) {
        int i = this.fChunks.size();
        while (i <= chunkNumber) {
            Chunk chunk = this.nextChunk();
            if (chunk == null) {
                int chunkCount = this.fChunks.size();
                this.fLength = chunkCount == 0 ? 0 : this.fChunks.get((int)(chunkCount - 1)).fCharEndOffset;
                break;
            }
            if (this.fHasher != null) {
                char[] chunkData = this.getChunkData(chunk);
                this.fHasher.addChunk(chunkData);
            }
            this.fChunks.add(chunk);
            ++i;
        }
        if (chunkNumber < this.fChunks.size()) {
            return this.fChunks.get(chunkNumber);
        }
        return null;
    }

    protected Chunk newChunk(long sourceOffset, long sourceEndOffset, int charOffset, char[] chars) {
        this.fCurrentChars = chars;
        return new Chunk(sourceOffset, sourceEndOffset, charOffset, chars);
    }

    protected abstract Chunk nextChunk();

    private char[] getChunkData(Chunk chunk) {
        char[] data = chunk.fCharsReference.get();
        if (data == null) {
            data = new char[chunk.fCharEndOffset - chunk.fCharOffset];
            this.rereadChunkData(chunk, data);
            chunk.fCharsReference = new SoftReference<char[]>(data);
        }
        this.fCurrentChars = data;
        return data;
    }

    protected abstract void rereadChunkData(Chunk var1, char[] var2);

    public void testClearData() {
        for (Chunk chunk : this.fChunks) {
            chunk.fCharsReference = new SoftReference<Object>(null);
        }
        if (this.fCurrentChars != null) {
            this.fCurrentChars = null;
        }
    }

    protected static class Chunk {
        final int fCharOffset;
        final int fCharEndOffset;
        final long fSourceOffset;
        final long fSourceEndOffset;
        private SoftReference<char[]> fCharsReference;

        private Chunk(long sourceOffset, long sourceEndOffset, int charOffset, char[] chars) {
            this.fCharOffset = charOffset;
            this.fCharEndOffset = charOffset + chars.length;
            this.fSourceOffset = sourceOffset;
            this.fSourceEndOffset = sourceEndOffset;
            this.fCharsReference = new SoftReference<char[]>(chars);
        }
    }
}

