/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tools.templates.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tools.templates.ui.internal.Tag;

public class TagListViewer
extends ListViewer {
    private Tag[] tags;

    public TagListViewer(Composite parent, int style) {
        super(parent, style);
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Tag) {
                    return ((Tag)element).getLabel();
                }
                return super.getText(element);
            }
        });
        this.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput != null) {
                    Collection tagsList = (Collection)newInput;
                    TagListViewer.this.tags = tagsList.toArray(new Tag[tagsList.size()]);
                    Arrays.sort(TagListViewer.this.tags, new Comparator<Tag>(){

                        @Override
                        public int compare(Tag o1, Tag o2) {
                            if (o1.getId().equals("all")) {
                                return -1;
                            }
                            if (o2.getId().equals("all")) {
                                return 1;
                            }
                            return o1.getLabel().compareTo(o2.getLabel());
                        }
                    });
                }
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return TagListViewer.this.tags;
            }
        });
    }

    public Collection<Tag> getSelectedTags() {
        ArrayList<Tag> selectedTags = new ArrayList<Tag>();
        for (Tag tag : this.getStructuredSelection()) {
            selectedTags.add(tag);
        }
        return selectedTags;
    }
}

