/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.core.datamodel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.core.JsonUtils;
import org.eclipse.embedcdt.core.Xml;
import org.eclipse.embedcdt.debug.gdbjtag.core.DebugUtils;
import org.eclipse.embedcdt.debug.gdbjtag.core.data.CProjectExtraDataManagerProxy;
import org.eclipse.embedcdt.debug.gdbjtag.core.data.SVDPathManagerProxy;
import org.eclipse.embedcdt.internal.debug.gdbjtag.core.Activator;
import org.eclipse.embedcdt.packs.core.IConsoleStream;
import org.eclipse.embedcdt.packs.core.data.IPacksDataManager;
import org.eclipse.embedcdt.packs.core.data.PacksDataManagerFactoryProxy;
import org.eclipse.embedcdt.packs.core.data.PacksStorage;
import org.eclipse.embedcdt.packs.core.data.SvdGenericParser;
import org.eclipse.embedcdt.packs.core.data.SvdJsGenericParser;
import org.eclipse.embedcdt.packs.core.data.XsvdGenericParser;
import org.eclipse.embedcdt.packs.core.data.xcdl.XcdlUtils;
import org.eclipse.embedcdt.packs.core.jstree.JsObject;
import org.eclipse.embedcdt.packs.core.tree.AbstractTreePreOrderIterator;
import org.eclipse.embedcdt.packs.core.tree.Leaf;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SvdUtils {
    private static long computeScale(String str) {
        String lastChar;
        long scale = 1L;
        if (!str.isEmpty() && (lastChar = str.substring(str.length() - 1)).matches("[kmgtKMGT]")) {
            if ("k".equals(lastChar = lastChar.toLowerCase())) {
                scale = 1024L;
            } else if ("m".equals(lastChar)) {
                scale = 0x100000L;
            } else if ("g".equals(lastChar)) {
                scale = 0x40000000L;
            } else if ("t".equals(lastChar)) {
                scale = 0L;
            }
        }
        return scale;
    }

    private static String adjustForScale(String str, long scale) {
        if (scale != 1L) {
            return str.substring(0, str.length() - 2);
        }
        return str;
    }

    private static int computeRadix(String str) {
        int radix = 10;
        if (str.startsWith("0x") || str.startsWith("0X")) {
            radix = 16;
        } else if (str.startsWith("0b") || str.startsWith("0B")) {
            radix = 2;
        } else if (str.startsWith("#")) {
            radix = 2;
        }
        return radix;
    }

    private static String adjustForRadix(String str) {
        if (str.startsWith("0x") || str.startsWith("0X")) {
            return str.substring(2);
        }
        if (str.startsWith("0b") || str.startsWith("0B")) {
            return str.substring(2);
        }
        if (str.startsWith("#")) {
            return str.substring(1);
        }
        return str;
    }

    private static String adjustForSign(String str) {
        if (str.startsWith("+")) {
            return str.substring(1);
        }
        return str;
    }

    public static long parseScaledNonNegativeLong(String str) throws NumberFormatException {
        str = SvdUtils.adjustForSign(str);
        int radix = SvdUtils.computeRadix(str);
        str = SvdUtils.adjustForRadix(str);
        long scale = SvdUtils.computeScale(str);
        str = SvdUtils.adjustForScale(str, scale);
        long value = Long.parseLong(str, radix);
        if (scale != 1L) {
            value *= scale;
        }
        return value;
    }

    public static BigInteger parseScaledNonNegativeBigInteger(String str) throws NumberFormatException {
        str = SvdUtils.adjustForSign(str);
        int radix = SvdUtils.computeRadix(str);
        str = SvdUtils.adjustForRadix(str);
        long scale = SvdUtils.computeScale(str);
        str = SvdUtils.adjustForScale(str, scale);
        BigInteger value = new BigInteger(str, radix);
        if (scale != 1L) {
            value = value.multiply(new BigInteger(String.valueOf(scale)));
        }
        return value;
    }

    public static IPath getSvdPath(ILaunchConfiguration launchConfiguration) throws CoreException {
        ICConfigurationDescription cConfigDescription = EclipseUtils.getBuildConfigDescription((ILaunchConfiguration)launchConfiguration);
        IProject project = cConfigDescription.getProjectDescription().getProject();
        String value = launchConfiguration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.svdPath", "");
        if (!value.isEmpty()) {
            File f = new File(value = SvdUtils.resolveAll(value, launchConfiguration));
            if (f.exists() && !f.isDirectory()) {
                return new Path(value);
            }
            Activator.log((String)("File '" + value + "' does not exist, searching packages."));
        }
        IConfiguration config = EclipseUtils.getConfigurationFromDescription((ICConfigurationDescription)cConfigDescription);
        String packType = "xpack.xcdl";
        String deviceId = null;
        String deviceVendorId = null;
        CProjectExtraDataManagerProxy dataManager = CProjectExtraDataManagerProxy.getInstance();
        Map<String, String> propertiesMap = dataManager.getExtraProperties(config);
        if (propertiesMap != null && !propertiesMap.isEmpty()) {
            packType = propertiesMap.get("pack.type");
            if (packType == null || "cmsis".equals(packType)) {
                deviceVendorId = propertiesMap.get("cmsis.device.vendor.id");
                deviceId = propertiesMap.get("cmsis.device.name");
            } else if ("xpack.xcdl".equals(packType)) {
                deviceVendorId = propertiesMap.get("device.vendor.id");
                deviceId = propertiesMap.get("device.id");
            }
        }
        IPath svdPath = null;
        if (deviceVendorId == null || deviceId == null) {
            try {
                JSONObject packageJson = XcdlUtils.getPackageJson((IProject)project);
                deviceId = (String)JsonUtils.get((JSONObject)packageJson, (String)"config.xcdl.device.id");
                deviceVendorId = (String)JsonUtils.get((JSONObject)packageJson, (String)"config.xcdl.device.supplier.id");
                svdPath = SvdUtils.getSvdProjectPath(project, packType, deviceVendorId, deviceId);
                File svdFile = svdPath.toFile();
                if (svdFile.isFile()) {
                    return svdPath;
                }
            }
            catch (IOException svdFile) {
            }
            catch (ParseException e) {
                Activator.log((Throwable)e);
            }
        }
        if (deviceVendorId == null || deviceId == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", "Assign a device to the project."));
        }
        svdPath = SvdUtils.getSvdPath(packType, deviceVendorId, deviceId, config);
        if (svdPath == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", "No peripherals available."));
        }
        File svdFile = svdPath.toFile();
        if (svdFile.isFile()) {
            return svdPath;
        }
        return null;
    }

    protected static IPath getSvdProjectPath(IProject project, String packType, String supplierId, String deviceName) {
        Path path = null;
        if ("xpack.xcdl".equals(packType)) {
            IPath projectPath = project.getLocation();
            File xpacksFolder = projectPath.append("xpacks").toFile();
            if (!xpacksFolder.isDirectory()) {
                return null;
            }
            File[] folders = xpacksFolder.listFiles();
            int i = 0;
            while (i < folders.length) {
                if (folders[i].isDirectory()) {
                    File[] xcdlFiles = folders[i].listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith("xcdl.json");
                        }
                    });
                    int j = 0;
                    while (j < xcdlFiles.length) {
                        System.out.println(xcdlFiles[j]);
                        String xsvd = SvdUtils.getSvdFromXcdl(xcdlFiles[j], supplierId, deviceName);
                        if (xsvd != null) {
                            path = new Path(folders[i].toString());
                            return path.append(xsvd);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSvdFromXcdl(File xcdlFile, String supplierId, String deviceName) {
        JSONParser parser = new JSONParser();
        try {
            Object familyName;
            FileReader reader = new FileReader(xcdlFile);
            JSONObject xcdlJson = (JSONObject)parser.parse((Reader)reader);
            JSONObject families = (JSONObject)JsonUtils.get((JSONObject)xcdlJson, (String)"mcus.families");
            if (families == null) {
                return null;
            }
            Iterator iterator = families.keySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                return null;
            } while (!((familyName = iterator.next()) instanceof String));
            JSONObject family = (JSONObject)families.get(familyName);
            String supplier = (String)JsonUtils.get((JSONObject)family, (String)"supplier.id");
            if (!supplierId.equals(supplier)) {
                return null;
            }
            JSONObject devices = (JSONObject)family.get((Object)"devices");
            if (devices == null) {
                return null;
            }
            JSONObject device = (JSONObject)devices.get((Object)deviceName);
            if (device != null) return (String)JsonUtils.get((JSONObject)device, (String)"debug.xsvd");
            return null;
        }
        catch (FileNotFoundException reader) {
            return null;
        }
        catch (IOException e) {
            Activator.log((String)e.getMessage());
            return null;
        }
        catch (ParseException e) {
            Activator.log((String)e.getMessage());
        }
        return null;
    }

    public static IPath getSvdPath(String packType, String deviceSupplierId, String deviceId, IConfiguration config) throws CoreException {
        IPath path = null;
        SVDPathManagerProxy pathManager = SVDPathManagerProxy.getInstance();
        path = pathManager.getSVDAbsolutePath(deviceSupplierId, deviceId);
        if (path == null) {
            IPacksDataManager dataManager = PacksDataManagerFactoryProxy.getInstance().createDataManager();
            if (dataManager == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", "Peripherals descriptions are available only via the CMSIS Packs plug-in."));
            }
            path = dataManager.getSVDAbsolutePath(packType, deviceSupplierId, deviceId, config);
            if (path == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", "There are no peripherals descriptions available, install the required xPacks or CMSIS Packs."));
            }
        }
        assert (path != null);
        return path;
    }

    public static Leaf getTree(IPath path) throws CoreException {
        assert (path != null);
        IConsoleStream out = Activator.getInstance().getConsoleOutput();
        try {
            File file = path.toFile();
            if (file == null) {
                out.println("Parsing SVD file \"" + path.toOSString() + "\"...");
                throw new IOException(path + " File object null.");
            }
            FileReader reader = null;
            reader = new FileReader(file);
            char[] chars = new char[10];
            reader.read(chars);
            reader.close();
            String str = "";
            str = chars[0] == '\ufeff' ? new String(Arrays.copyOfRange(chars, 1, chars.length - 1)).trim() : new String(chars).trim();
            IPath actualPath = path;
            if (str.startsWith("PK")) {
                out.println("Decompressing zipped SVD file \"" + path.toOSString() + "\"...");
                ZipInputStream zipInput = new ZipInputStream(new FileInputStream(file));
                ZipEntry zipEntry = zipInput.getNextEntry();
                while (zipEntry != null) {
                    if (!zipEntry.isDirectory()) {
                        int bytesRead;
                        String fileName = zipEntry.getName();
                        File outFile = PacksStorage.getCachedFileObject((String)fileName);
                        if (!outFile.getParentFile().exists()) {
                            outFile.getParentFile().mkdirs();
                        }
                        out.println("Writing \"" + outFile + "\"...");
                        FileOutputStream output = new FileOutputStream(outFile);
                        byte[] buf = new byte[1024];
                        while ((bytesRead = zipInput.read(buf)) > 0) {
                            ((OutputStream)output).write(buf, 0, bytesRead);
                        }
                        ((OutputStream)output).close();
                        actualPath = new Path(outFile.getAbsolutePath());
                        break;
                    }
                    zipEntry = zipInput.getNextEntry();
                }
                zipInput.closeEntry();
                zipInput.close();
                file = actualPath.toFile();
                reader = new FileReader(file);
                chars = new char[10];
                reader.read(chars);
                reader.close();
                str = " ";
                str = chars[0] == '\ufeff' ? new String(Arrays.copyOfRange(chars, 1, chars.length - 1)).trim() : new String(chars).trim();
            }
            out.println("Parsing SVD file \"" + actualPath.toOSString() + "\"...");
            if (str.startsWith("<?xml ")) {
                Document document = Xml.parseFile((File)file);
                SvdJsGenericParser jsParser = new SvdJsGenericParser();
                JsObject jsObject = jsParser.parse(document);
                System.out.println(jsObject);
                SvdGenericParser parser = new SvdGenericParser();
                return parser.parse(document);
            }
            if (str.startsWith("{")) {
                JSONParser parser = new JSONParser();
                reader = new FileReader(file);
                JSONObject json = (JSONObject)parser.parse((Reader)reader);
                XsvdGenericParser jsonParser = new XsvdGenericParser();
                return jsonParser.parse(json);
            }
            String serr = "File format does not look like XML, JSON or ZIP";
            Activator.log((String)serr);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", serr));
        }
        catch (ParserConfigurationException e) {
            Activator.log((Throwable)e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", "Failed to get the peripherals descriptions.", (Throwable)e));
        }
        catch (SAXParseException e) {
            Activator.log((Throwable)e);
            String msg = "Failed to parse the peripherals descriptions, line: " + e.getLineNumber() + ", column: " + e.getColumnNumber() + ".";
            throw new CoreException((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", msg, (Throwable)e));
        }
        catch (SAXException e) {
            Activator.log((Throwable)e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", "Failed to parse the peripherals descriptions.", (Throwable)e));
        }
        catch (IOException e) {
            Activator.log((Throwable)e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", "Failed to get the peripherals descriptions.", (Throwable)e));
        }
        catch (ParseException e) {
            Activator.log((Throwable)e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", "Failed to parse the JSON.", (Throwable)e));
        }
    }

    public static List<Leaf> getPeripherals(Leaf tree) {
        LinkedList<Leaf> list = new LinkedList<Leaf>();
        if (tree != null) {
            class SvdPeriphIterator
            extends AbstractTreePreOrderIterator {
                SvdPeriphIterator() {
                }

                public boolean isIterable(Leaf node) {
                    return node.isType("peripheral");
                }

                public boolean isLeaf(Leaf node) {
                    return node.isType("peripheral");
                }
            }
            SvdPeriphIterator peripheralNodes = new SvdPeriphIterator();
            peripheralNodes.setTreeNode(tree);
            Iterator iterator = peripheralNodes.iterator();
            while (iterator.hasNext()) {
                Leaf peripheral = (Leaf)iterator.next();
                list.add(peripheral);
            }
            if (!list.isEmpty()) {
                return list;
            }
        }
        return list;
    }

    public static String resolveAll(String str, ILaunchConfiguration configuration) throws CoreException {
        String value = str;
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        if (value.indexOf("${") >= 0) {
            value = DebugUtils.resolveAll(value, configuration.getAttributes());
            ICConfigurationDescription buildConfig = EclipseUtils.getBuildConfigDescription((ILaunchConfiguration)configuration);
            if (buildConfig != null) {
                value = DebugUtils.resolveAll(value, buildConfig);
            }
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("gdbjtag.resolveAll(\"" + str + "\") = \"" + value + "\"");
        }
        return value;
    }
}

