/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.ProjectProperties;
import org.eclipse.wst.server.core.internal.RuntimeProxy;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.ServerTypeProxy;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.ui.internal.EclipseUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class WizardTaskUtil {
    public static final String TASK_LAUNCHABLE_ADAPTER = "launchableAdapter";
    public static final String TASK_LAUNCHABLE = "launchable";
    public static final String TASK_CLIENT = "client";
    public static final String TASK_CLIENTS = "clients";
    public static final String TASK_DEFAULT_SERVER = "defaultServer";
    public static final String TASK_MODE = "mode";
    public static final String TASK_HAS_TASKS = "hasTasks";
    public static final String TASK_HAS_CLIENTS = "hasClients";
    public static final String TASK_FEATURE = "feature";
    public static final byte MODE_EXISTING = 0;
    public static final byte MODE_DETECT = 1;
    public static final byte MODE_MANUAL = 2;
    public static final WizardFragment SaveRuntimeFragment = new WizardFragment(){

        @Override
        public void performFinish(IProgressMonitor monitor) throws CoreException {
            WizardTaskUtil.saveRuntime(this.getTaskModel(), monitor);
        }
    };
    public static final WizardFragment SaveServerFragment = new WizardFragment(){

        @Override
        public void performFinish(IProgressMonitor monitor) throws CoreException {
            WizardTaskUtil.saveServer(this.getTaskModel(), monitor);
        }
    };
    public static final WizardFragment TempSaveRuntimeFragment = new WizardFragment(){

        @Override
        public void performFinish(IProgressMonitor monitor) throws CoreException {
            WizardTaskUtil.tempSaveRuntime(this.getTaskModel(), monitor);
        }
    };
    public static final WizardFragment TempSaveServerFragment = new WizardFragment(){

        @Override
        public void performFinish(IProgressMonitor monitor) throws CoreException {
            WizardTaskUtil.tempSaveServer(this.getTaskModel(), monitor);
        }
    };
    public static final WizardFragment SaveHostnameFragment = new WizardFragment(){

        @Override
        public void performFinish(IProgressMonitor monitor) throws CoreException {
            try {
                IServerAttributes server2 = (IServerAttributes)this.getTaskModel().getObject("server");
                ServerUIPlugin.getPreferences().addHostname(server2.getHost());
            }
            catch (Exception exception) {}
        }
    };

    private WizardTaskUtil() {
    }

    protected static void saveRuntime(TaskModel taskModel, IProgressMonitor monitor) throws CoreException {
        IRuntimeWorkingCopy workingCopy;
        IRuntime runtime = (IRuntime)taskModel.getObject("runtime");
        if (runtime != null && runtime instanceof IRuntimeWorkingCopy && (workingCopy = (IRuntimeWorkingCopy)runtime).isDirty()) {
            taskModel.putObject("runtime", (Object)workingCopy.save(false, monitor));
        }
    }

    protected static void saveServer(TaskModel taskModel, IProgressMonitor monitor) throws CoreException {
        IServer server = (IServer)taskModel.getObject("server");
        if (server != null && server instanceof IServerWorkingCopy) {
            IServerWorkingCopy workingCopy = (IServerWorkingCopy)server;
            if (workingCopy.getServerType() instanceof ServerTypeProxy) {
                return;
            }
            if (workingCopy.isDirty()) {
                IFile file = ((Server)workingCopy).getFile();
                if (file != null) {
                    ProjectProperties pp;
                    IProject project = file.getProject();
                    if (!file.getProject().exists()) {
                        EclipseUtil.createNewServerProject(null, project.getName(), null, monitor);
                    }
                    if (!(pp = ServerPlugin.getProjectProperties((IProject)project)).isServerProject()) {
                        pp.setServerProject(true, monitor);
                    }
                }
                taskModel.putObject("server", (Object)workingCopy.save(false, monitor));
            }
        }
    }

    protected static void tempSaveRuntime(TaskModel taskModel, IProgressMonitor monitor) throws CoreException {
        IRuntime runtime = (IRuntime)taskModel.getObject("runtime");
        if (runtime != null && runtime instanceof IRuntimeWorkingCopy) {
            IRuntimeWorkingCopy workingCopy = (IRuntimeWorkingCopy)runtime;
            if (!workingCopy.isDirty()) {
                return;
            }
            runtime = workingCopy.save(false, monitor);
            taskModel.putObject("runtime", (Object)runtime.createWorkingCopy());
        }
    }

    protected static void tempSaveServer(TaskModel taskModel, IProgressMonitor monitor) throws CoreException {
        IServer server = (IServer)taskModel.getObject("server");
        if (server != null && server instanceof IServerWorkingCopy) {
            IRuntime runtime;
            IServerWorkingCopy workingCopy = (IServerWorkingCopy)server;
            if (!workingCopy.isDirty()) {
                return;
            }
            IFile file = ((Server)workingCopy).getFile();
            if (file != null) {
                ProjectProperties pp;
                IProject project = file.getProject();
                if (!file.getProject().exists()) {
                    EclipseUtil.createNewServerProject(null, project.getName(), null, monitor);
                }
                if (!(pp = ServerPlugin.getProjectProperties((IProject)project)).isServerProject()) {
                    pp.setServerProject(true, monitor);
                }
            }
            if ((runtime = workingCopy.getRuntime()) instanceof RuntimeProxy) {
                return;
            }
            server = workingCopy.save(false, monitor);
            workingCopy = server.createWorkingCopy();
            workingCopy.setRuntime(runtime);
            if (workingCopy.getServerType().hasServerConfiguration()) {
                ((ServerWorkingCopy)workingCopy).importRuntimeConfiguration(runtime, null);
            }
            taskModel.putObject("server", (Object)workingCopy);
        }
    }

    public static void addModule(IModule module, TaskModel taskModel, IProgressMonitor monitor) throws CoreException {
        IModule parentModule;
        IServer server;
        block7: {
            if (module == null) {
                return;
            }
            server = (IServer)taskModel.getObject("server");
            parentModule = null;
            try {
                IModule[] parents = server.getRootModules(module, monitor);
                if (parents != null && parents.length > 0) {
                    parentModule = parents[0];
                }
            }
            catch (Exception e) {
                if (!Trace.WARNING) break block7;
                Trace.trace("/warning", "Could not find parent module", e);
            }
        }
        if (parentModule == null) {
            parentModule = module;
        }
        IModule[] modules = server.getModules();
        int size = modules.length;
        int i = 0;
        while (i < size) {
            if (parentModule.equals(modules[i])) {
                return;
            }
            ++i;
        }
        IServerWorkingCopy workingCopy = server.createWorkingCopy();
        workingCopy.modifyModules(new IModule[]{parentModule}, new IModule[0], monitor);
        taskModel.putObject("server", (Object)workingCopy.save(false, monitor));
    }

    public static void modifyModules(List<IModule> add, List<IModule> remove, TaskModel taskModel, IProgressMonitor monitor) throws CoreException {
        IFile file;
        if ((add == null || add.isEmpty()) && (remove == null || remove.isEmpty())) {
            return;
        }
        IServerWorkingCopy workingCopy = (IServerWorkingCopy)taskModel.getObject("server");
        IModule[] remove2 = new IModule[]{};
        if (remove != null) {
            remove2 = new IModule[remove.size()];
            remove.toArray(remove2);
        }
        IModule[] add2 = new IModule[]{};
        if (add != null) {
            add2 = new IModule[add.size()];
            add.toArray(add2);
        }
        if ((file = ((Server)workingCopy).getFile()) != null) {
            ProjectProperties pp;
            IProject project = file.getProject();
            if (!file.getProject().exists()) {
                EclipseUtil.createNewServerProject(null, project.getName(), null, monitor);
            }
            if (!(pp = ServerPlugin.getProjectProperties((IProject)project)).isServerProject()) {
                pp.setServerProject(true, monitor);
            }
        }
        workingCopy.modifyModules(add2, remove2, monitor);
    }
}

