/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.contentproperties.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.css.core.internal.contentproperties.CSSContentProperties;
import org.eclipse.wst.css.core.internal.metamodel.CSSProfile;
import org.eclipse.wst.css.core.internal.metamodel.CSSProfileRegistry;
import org.eclipse.wst.css.ui.internal.CSSUIMessages;
import org.eclipse.wst.css.ui.internal.Logger;

public final class CSSWebContentSettingsPropertyPage
extends PropertyPage {
    private static final String SELECT_NONE = CSSUIMessages.UI_none;
    private Combo fProfileCombo;
    private List fProfileIds;

    public CSSWebContentSettingsPropertyPage() {
        this.setDescription(CSSUIMessages.CSSContentSettingsPropertyPage_0);
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalIndent = 0;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected Control createContents(Composite parent) {
        Composite propertyPage = this.createComposite(parent, 2);
        Text languageLabel = new Text(propertyPage, 8);
        languageLabel.setText(CSSUIMessages.CSSContentSettingsPropertyPage_1);
        this.fProfileCombo = new Combo(propertyPage, 8);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalIndent = 0;
        this.fProfileCombo.setLayoutData((Object)data);
        this.populateValues();
        this.initializeValues();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)propertyPage, "org.eclipse.wst.css.ui.misc0180");
        Dialog.applyDialogFont((Control)parent);
        return propertyPage;
    }

    private IResource getResource() {
        IResource resource = null;
        if (this.getElement() instanceof IResource) {
            resource = (IResource)this.getElement();
        }
        return resource;
    }

    private void initializeValues() {
        int index = 0;
        String profile = CSSContentProperties.getProperty((String)"css-profile", (IResource)this.getResource(), (boolean)false);
        if (profile != null && profile.length() > 0) {
            index = this.fProfileIds.indexOf(profile);
        }
        index = index >= 0 ? index : 0;
        this.fProfileCombo.select(index);
    }

    private void populateValues() {
        this.fProfileIds = new ArrayList();
        this.fProfileCombo.add(SELECT_NONE);
        this.fProfileIds.add(null);
        CSSProfileRegistry reg = CSSProfileRegistry.getInstance();
        Iterator i = reg.getProfiles();
        while (i.hasNext()) {
            CSSProfile profile = (CSSProfile)i.next();
            String id = profile.getProfileID();
            String name = profile.getProfileName();
            this.fProfileCombo.add(name);
            this.fProfileIds.add(id);
        }
    }

    protected void performDefaults() {
        int index = this.fProfileCombo.indexOf(SELECT_NONE);
        if (index > -1) {
            this.fProfileCombo.select(index);
        }
        super.performDefaults();
    }

    public boolean performOk() {
        int index = this.fProfileCombo.getSelectionIndex();
        if (index > -1) {
            String id = (String)this.fProfileIds.get(index);
            if (id == null || id.length() == 0 || id.equalsIgnoreCase(SELECT_NONE)) {
                id = null;
            }
            try {
                CSSContentProperties.setProperty((String)"css-profile", (IResource)this.getResource(), (String)id);
            }
            catch (CoreException e) {
                Logger.log(202, e.getMessage(), e);
            }
        }
        return super.performOk();
    }
}

