/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.search;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.AbstractSearchHandler;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.AbstractDuplicateDetector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class StackTraceDuplicateDetector
extends AbstractDuplicateDetector {
    public boolean canQuery(TaskData taskData) {
        return TasksUiPlugin.getDefault().getSearchHandler(taskData.getConnectorKind()) != null;
    }

    private String getDescription(TaskData taskData) {
        TaskAttribute attribute = taskData.getRoot().getMappedAttribute("task.common.description");
        if (attribute == null) {
            attribute = taskData.getRoot().getMappedAttribute("task.common.comment.new");
        }
        return attribute != null ? attribute.getTaskData().getAttributeMapper().getValueLabel(attribute) : "";
    }

    public IRepositoryQuery getDuplicatesQuery(TaskRepository taskRepository, TaskData taskData) throws CoreException {
        String description = this.getDescription(taskData);
        String searchString = StackTraceDuplicateDetector.getStackTraceFromDescription(description);
        if (searchString == null) {
            throw new CoreException((IStatus)new Status(1, "org.eclipse.mylyn.tasks.ui", "Unable to locate a stack trace in the description text."));
        }
        IRepositoryQuery query = TasksUi.getRepositoryModel().createRepositoryQuery(taskRepository);
        AbstractSearchHandler searchHandler = TasksUiPlugin.getDefault().getSearchHandler(taskRepository.getConnectorKind());
        if (searchHandler.queryForText(taskRepository, query, taskData, searchString)) {
            return query;
        }
        return null;
    }

    public static String getStackTraceFromDescription(String description) {
        String stackTrace = null;
        if (description == null) {
            return null;
        }
        String punct = "!\"#$%&'\\(\\)*+,-./:;\\<=\\>?@\\[\\]^_`\\{|\\}~\n";
        String lineRegex = " *at\\s+[\\w" + punct + "]+ ?\\(.*\\) *\n?";
        Pattern tracePattern = Pattern.compile(lineRegex);
        Matcher match = tracePattern.matcher(description);
        if (match.find()) {
            int start = match.start();
            int lastEnd = match.end();
            while (match.find()) {
                lastEnd = match.end();
            }
            if (start <= 0) {
                return null;
            }
            int stackStart = 0;
            int index = start - 1;
            while (index > 1 && description.charAt(index) == ' ') {
                --index;
            }
            stackStart = description.substring(0, index - 1).lastIndexOf("\n");
            stackStart = stackStart == -1 ? 0 : stackStart + 1;
            stackTrace = description.substring(stackStart, lastEnd);
        }
        return stackTrace;
    }
}

