/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import java.io.FileNotFoundException;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.tmf.core.component.TmfEventProvider;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfIterator;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfCheckpoint;

public class CtfTmfTrace
extends TmfEventProvider<CtfTmfEvent>
implements ITmfTrace<CtfTmfEvent> {
    public static final int DEFAULT_INDEX_PAGE_SIZE = 50000;
    private CTFTrace fTrace;
    protected int fIndexPageSize = 50000;
    private Vector<TmfCheckpoint> fCheckpoints = new Vector();
    protected long fNbEvents = 0L;
    private ITmfTimestamp fStartTime = TmfTimestamp.BIG_CRUNCH;
    private ITmfTimestamp fEndTime = TmfTimestamp.BIG_BANG;
    private IResource fResource;
    protected CtfIterator iterator;

    @Override
    public void initTrace(String name, String path, Class<CtfTmfEvent> eventType) throws FileNotFoundException {
        try {
            this.fTrace = new CTFTrace(path);
        }
        catch (CTFReaderException e) {
            System.err.println("Cannot find file " + path);
            throw new FileNotFoundException(e.getMessage());
        }
        this.iterator = new CtfIterator(this, 0L, 0L);
        this.setStartTime(this.iterator.getCurrentEvent().getTimestamp());
        TmfSignalManager.register(this);
    }

    @Override
    public void initTrace(String name, String path, Class<CtfTmfEvent> eventType, int cacheSize) throws FileNotFoundException {
        this.initTrace(name, path, eventType);
    }

    @Override
    public void initTrace(String name, String path, Class<CtfTmfEvent> eventType, boolean indexTrace) throws FileNotFoundException {
        this.initTrace(name, path, eventType);
    }

    @Override
    public void initTrace(String name, String path, Class<CtfTmfEvent> eventType, int cacheSize, boolean indexTrace) throws FileNotFoundException {
        this.initTrace(name, path, eventType);
    }

    @Override
    public void dispose() {
        TmfSignalManager.deregister(this);
    }

    @Override
    public void broadcast(TmfSignal signal) {
        TmfSignalManager.dispatchSignal(signal);
    }

    @Override
    public boolean validate(IProject project, String path) {
        try {
            CTFTrace temp = new CTFTrace(path);
            return temp.majortIsSet();
        }
        catch (CTFReaderException cTFReaderException) {
            return false;
        }
    }

    public CtfTmfTrace clone() throws CloneNotSupportedException {
        CtfTmfTrace clone = null;
        clone = (CtfTmfTrace)super.clone();
        clone.setfCheckpoints(this.fCheckpoints);
        clone.fStartTime = this.fStartTime.clone();
        clone.fEndTime = this.fEndTime.clone();
        clone.fTrace = this.fTrace;
        return clone;
    }

    @Override
    public ITmfTrace<CtfTmfEvent> copy() {
        return null;
    }

    @Override
    public String getPath() {
        return this.fTrace.getPath();
    }

    @Override
    public String getName() {
        String[] temp = this.fTrace.getPath().split(System.getProperty("file.separator"));
        if (temp.length > 2) {
            return temp[temp.length - 1];
        }
        return temp[0];
    }

    @Override
    public int getCacheSize() {
        return this.fIndexPageSize;
    }

    @Override
    public long getNbEvents() {
        return this.fNbEvents;
    }

    @Override
    public TmfTimeRange getTimeRange() {
        return new TmfTimeRange(this.fStartTime, this.fEndTime);
    }

    @Override
    public ITmfTimestamp getStartTime() {
        return this.fStartTime;
    }

    @Override
    public ITmfTimestamp getEndTime() {
        return this.fEndTime;
    }

    @Override
    public ITmfLocation<?> getCurrentLocation() {
        return this.iterator.getLocation();
    }

    @Override
    public long getRank(ITmfTimestamp timestamp) {
        ITmfContext context = this.seekEvent(timestamp);
        return context.getRank();
    }

    protected void setTimeRange(TmfTimeRange range) {
        this.fStartTime = range.getStartTime();
        this.fEndTime = range.getEndTime();
    }

    protected void setStartTime(ITmfTimestamp startTime) {
        this.fStartTime = startTime;
    }

    protected void setEndTime(ITmfTimestamp endTime) {
        this.fEndTime = endTime;
    }

    @Override
    public ITmfContext armRequest(ITmfDataRequest<CtfTmfEvent> request) {
        if (request instanceof ITmfEventRequest && !TmfTimestamp.BIG_BANG.equals(((ITmfEventRequest)request).getRange().getStartTime()) && request.getIndex() == 0) {
            ITmfContext context = this.seekEvent(((ITmfEventRequest)request).getRange().getStartTime());
            ((ITmfEventRequest)request).setStartIndex((int)context.getRank());
            return context;
        }
        return this.seekEvent(request.getIndex());
    }

    @Override
    public CtfTmfEvent getNext(ITmfContext context) {
        this.iterator.advance();
        return this.iterator.getCurrentEvent();
    }

    @Override
    public ITmfContext seekLocation(ITmfLocation<?> location) {
        this.iterator.setLocation(location);
        return this.iterator;
    }

    @Override
    public double getLocationRatio(ITmfLocation<?> location) {
        return 0.0;
    }

    @Override
    public long getStreamingInterval() {
        return 0L;
    }

    @Override
    public ITmfContext seekEvent(ITmfTimestamp timestamp) {
        this.iterator.seek(timestamp.getValue());
        return this.iterator;
    }

    @Override
    public ITmfContext seekEvent(long rank) {
        this.iterator.setRank(rank);
        return this.iterator;
    }

    @Override
    public ITmfContext seekLocation(double ratio) {
        this.iterator.seek((long)((double)this.fNbEvents * ratio));
        return this.iterator;
    }

    @Override
    public CtfTmfEvent getNextEvent(ITmfContext context) {
        this.iterator.advance();
        return this.iterator.getCurrentEvent();
    }

    @Override
    public CtfTmfEvent parseEvent(ITmfContext context) {
        return this.iterator.getCurrentEvent();
    }

    public Vector<TmfCheckpoint> getfCheckpoints() {
        return this.fCheckpoints;
    }

    public void setfCheckpoints(Vector<TmfCheckpoint> fCheckpoints) {
        this.fCheckpoints = fCheckpoints;
    }

    @Override
    public IResource getResource() {
        return this.fResource;
    }

    @Override
    public void setResource(IResource fResource) {
        this.fResource = fResource;
    }

    CTFTrace getCTFTrace() {
        return this.fTrace;
    }
}

