/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.statesystem.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.statesystem.AttributeTree;
import org.eclipse.linuxtools.tmf.core.statesystem.StateSystem;
import org.eclipse.linuxtools.tmf.core.statesystem.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.statesystem.TransientState;
import org.eclipse.linuxtools.tmf.core.statesystem.helpers.IStateHistoryBackend;

public class StateHistorySystem
extends StateSystem {
    private final IStateHistoryBackend backend;
    private ArrayList<ITmfStateInterval> currentStateInfo;

    public StateHistorySystem(IStateHistoryBackend backend, boolean newFile) throws IOException {
        this.backend = backend;
        this.transState = new TransientState(backend);
        this.currentStateInfo = new ArrayList();
        if (newFile) {
            this.attributeTree = new AttributeTree(this);
        } else {
            FileInputStream attributeTreeInput = backend.supplyAttributeTreeReader();
            this.attributeTree = new AttributeTree(this, attributeTreeInput);
            this.transState.setInactive();
        }
    }

    public IStateHistoryBackend getHistoryBackend() {
        return this.backend;
    }

    public void closeHistory(long endTime) throws TimeRangeException {
        long realEndTime = endTime;
        if (realEndTime < this.backend.getEndTime()) {
            realEndTime = this.backend.getEndTime();
        }
        this.transState.closeTransientState(realEndTime);
        this.backend.finishedBuilding(realEndTime);
        File attributeTreeFile = this.backend.supplyAttributeTreeWriterFile();
        long attributeTreeFilePos = this.backend.supplyAttributeTreeWriterFilePosition();
        if (attributeTreeFile != null) {
            this.attributeTree.writeSelf(attributeTreeFile, attributeTreeFilePos);
        }
    }

    public synchronized void loadStateAtTime(long t) throws TimeRangeException {
        this.currentStateInfo = new ArrayList(this.attributeTree.getNbAttributes());
        int i = 0;
        while (i < this.attributeTree.getNbAttributes()) {
            this.currentStateInfo.add(null);
            ++i;
        }
        this.backend.doQuery(this.currentStateInfo, t);
        if (this.transState.isActive()) {
            this.transState.doQuery(this.currentStateInfo, t);
        }
        for (ITmfStateInterval interval : this.currentStateInfo) {
            assert (interval != null);
        }
    }

    public ITmfStateInterval queryState(int attributeQuark) {
        return this.currentStateInfo.get(attributeQuark);
    }

    public ITmfStateInterval querySingleState(long t, int attributeQuark) throws AttributeNotFoundException, TimeRangeException {
        ITmfStateInterval ret = this.transState.hasInfoAboutStateOf(t, attributeQuark) ? this.transState.getOngoingInterval(attributeQuark) : this.backend.doSingularQuery(t, attributeQuark);
        assert (ret != null);
        return ret;
    }

    public List<ITmfStateInterval> queryHistoryRange(int attributeQuark, long t1, long t2) throws TimeRangeException, AttributeNotFoundException {
        if (!this.backend.checkValidTime(t1) || !this.backend.checkValidTime(t2)) {
            throw new TimeRangeException();
        }
        ArrayList<ITmfStateInterval> intervals = new ArrayList<ITmfStateInterval>();
        ITmfStateInterval currentInterval = this.querySingleState(t1, attributeQuark);
        intervals.add(currentInterval);
        long ts = currentInterval.getEndTime();
        while (ts != -1L && ts <= t2) {
            currentInterval = this.querySingleState(++ts, attributeQuark);
            intervals.add(currentInterval);
            ts = currentInterval.getEndTime();
        }
        return intervals;
    }

    @Override
    public void debugPrint(PrintWriter writer) {
        writer.println("------------------------------");
        writer.println("Current State Info vector:\n");
        int i = 0;
        while (i < this.currentStateInfo.size()) {
            writer.print(String.valueOf(i) + "\t\t");
            if (this.currentStateInfo.get(i) == null) {
                writer.println("null");
            } else {
                writer.println(this.currentStateInfo.get(i).toString());
            }
            ++i;
        }
        writer.println('\n');
        super.debugPrint(writer);
        this.backend.debugPrint(writer);
    }
}

