/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.overlay.modulecore;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2e.wtp.overlay.internal.Messages;
import org.eclipse.m2e.wtp.overlay.internal.modulecore.OverlaySelfComponent;
import org.eclipse.m2e.wtp.overlay.internal.modulecore.OverlayVirtualArchiveComponent;
import org.eclipse.m2e.wtp.overlay.internal.modulecore.OverlayVirtualComponent;
import org.eclipse.m2e.wtp.overlay.modulecore.IOverlayVirtualComponent;
import org.eclipse.m2e.wtp.overlay.modulecore.ModuleURIUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ComponentcorePackage;
import org.eclipse.wst.common.componentcore.internal.DependencyType;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.resolvers.IReferenceResolver;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class OverlayReferenceResolver
implements IReferenceResolver {
    public static final String PROTOCOL = "module:/overlay/";
    public static final String PROJECT_PROTOCOL = "module:/overlay/prj/";
    public static final String VAR_ARCHIVE_PROTOCOL = "module:/overlay/var/";
    public static final String SELF_PROTOCOL = "module:/overlay/slf/";
    private static final String UNPACK_FOLDER = "unpackFolder";
    private static final String INCLUDES = "includes";
    private static final String EXCLUDES = "excludes";

    public boolean canResolve(IVirtualComponent component, ReferencedComponent referencedComponent) {
        URI uri = referencedComponent.getHandle();
        return uri != null && uri.segmentCount() > 2 && uri.segment(0).equals("overlay");
    }

    public IVirtualReference resolve(IVirtualComponent component, ReferencedComponent referencedComponent) {
        String type = referencedComponent.getHandle().segment(1);
        IOverlayVirtualComponent comp = null;
        String url = referencedComponent.getHandle().toString();
        Map<String, String> parameters = ModuleURIUtil.parseUri(url);
        String moduleName = ModuleURIUtil.extractModuleName(url);
        if (moduleName == null || moduleName.trim().length() == 0) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.OverlayReferenceResolver_Module_Name_Cant_Be_Inferred, (Object)url));
        }
        if ("prj".equals(type)) {
            comp = this.createProjectComponent(component, moduleName.substring(PROJECT_PROTOCOL.length()));
        } else if ("var".equals(type)) {
            String unpackFolder = parameters.get(UNPACK_FOLDER);
            if (unpackFolder == null || unpackFolder.trim().length() == 0) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.OverlayReferenceResolver_Missing_Parameter, (Object)url, (Object)UNPACK_FOLDER));
            }
            comp = this.createArchivecomponent(component, moduleName.substring(PROTOCOL.length()), unpackFolder, referencedComponent.getRuntimePath());
        } else if ("slf".equals(type)) {
            comp = this.createSelfComponent(component);
        }
        if (comp == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.OverlayReferenceResolver_Unresolveable, (Object)referencedComponent.getHandle()));
        }
        comp.setInclusions(this.getPatternSet(parameters.get(INCLUDES)));
        comp.setExclusions(this.getPatternSet(parameters.get(EXCLUDES)));
        IVirtualReference ref = ComponentCore.createReference((IVirtualComponent)component, (IVirtualComponent)comp);
        ref.setArchiveName(referencedComponent.getArchiveName());
        ref.setRuntimePath(referencedComponent.getRuntimePath());
        ref.setDependencyType(referencedComponent.getDependencyType().getValue());
        return ref;
    }

    private Set<String> getPatternSet(String patterns) {
        if (patterns == null || patterns.trim().length() == 0) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> patternSet = new LinkedHashSet<String>();
        String[] stringArray = patterns.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            patternSet.add(pattern);
            ++n2;
        }
        return patternSet;
    }

    private IOverlayVirtualComponent createSelfComponent(IVirtualComponent component) {
        return new OverlaySelfComponent(component.getProject());
    }

    private IOverlayVirtualComponent createArchivecomponent(IVirtualComponent component, String url, String targetPath, IPath runtimePath) {
        return new OverlayVirtualArchiveComponent(component.getProject(), url, component.getProject().getFolder(targetPath).getProjectRelativePath(), runtimePath);
    }

    private IOverlayVirtualComponent createProjectComponent(IVirtualComponent component, String name) {
        IProject p = null;
        p = "".equals(name) ? component.getProject() : ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (p == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.OverlayReferenceResolver_Not_Workspace_Project, (Object)name));
        }
        return new OverlayVirtualComponent(p);
    }

    public boolean canResolve(IVirtualReference reference) {
        return reference != null && reference.getReferencedComponent() instanceof IOverlayVirtualComponent;
    }

    public ReferencedComponent resolve(IVirtualReference reference) {
        if (this.canResolve(reference)) {
            URI handle;
            IOverlayVirtualComponent comp = (IOverlayVirtualComponent)reference.getReferencedComponent();
            ReferencedComponent rc = ComponentcorePackage.eINSTANCE.getComponentcoreFactory().createReferencedComponent();
            rc.setArchiveName(reference.getArchiveName());
            rc.setRuntimePath(reference.getRuntimePath());
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(3);
            if (comp instanceof OverlayVirtualArchiveComponent) {
                OverlayVirtualArchiveComponent archivecomp = (OverlayVirtualArchiveComponent)comp;
                handle = URI.createURI((String)(VAR_ARCHIVE_PROTOCOL + archivecomp.getArchivePath().toPortableString()));
                parameters.put(UNPACK_FOLDER, archivecomp.getUnpackFolderPath().toPortableString());
            } else {
                IProject p = comp.getProject();
                handle = p.equals((Object)reference.getEnclosingComponent().getProject()) ? URI.createURI((String)SELF_PROTOCOL) : URI.createURI((String)(PROJECT_PROTOCOL + p.getName()));
            }
            parameters.put(INCLUDES, this.flatten(comp.getInclusions()));
            parameters.put(EXCLUDES, this.flatten(comp.getExclusions()));
            handle = URI.createURI((String)ModuleURIUtil.appendToUri(handle.toString(), parameters));
            rc.setHandle(handle);
            rc.setDependencyType(DependencyType.CONSUMES_LITERAL);
            return rc;
        }
        return null;
    }

    private String flatten(Set<String> patterns) {
        StringBuilder sb = new StringBuilder();
        if (patterns != null) {
            boolean initialized = false;
            for (String pattern : patterns) {
                if (initialized) {
                    sb.append(";");
                } else {
                    initialized = true;
                }
                sb.append(pattern);
            }
        }
        return sb.toString();
    }
}

