/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.jsf.internal.utils;

import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2e.wtp.ProjectUtils;
import org.eclipse.m2e.wtp.jsf.internal.MavenJSFConstants;
import org.eclipse.m2e.wtp.jsf.internal.Messages;
import org.eclipse.m2e.wtp.jsf.internal.utils.FacesConfigQuickPeek;
import org.eclipse.m2e.wtp.jsf.internal.utils.xpl.JSFAppConfigUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class JSFUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JSFUtils.class);
    public static final String FACES_SERVLET = "javax.faces.webapp.FacesServlet";
    private static final String FACES_SERVLET_XPATH = "//servlet[servlet-class=\"javax.faces.webapp.FacesServlet\"]";

    private JSFUtils() {
    }

    public static IFile getFacesconfig(IProject project) {
        IFile facesConfig = null;
        List<String> configFiles = JSFAppConfigUtils.getConfigFilesFromContextParam(project);
        for (String configFile : configFiles) {
            facesConfig = ProjectUtils.getWebResourceFile((IProject)project, (String)configFile);
            if (facesConfig == null || !facesConfig.exists()) continue;
            return facesConfig;
        }
        facesConfig = ProjectUtils.getWebResourceFile((IProject)project, (String)"WEB-INF/faces-config.xml");
        return facesConfig;
    }

    public static String getVersionFromFacesconfig(IProject project) {
        String version;
        block6: {
            IFile facesConfig = JSFUtils.getFacesconfig(project);
            version = null;
            if (facesConfig != null) {
                InputStream in = null;
                try {
                    try {
                        facesConfig.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                        in = facesConfig.getContents();
                        FacesConfigQuickPeek peek = new FacesConfigQuickPeek(in);
                        version = peek.getVersion();
                    }
                    catch (CoreException e) {
                        LOG.error(Messages.JSFUtils_Error_Reading_FacesConfig, (Throwable)e);
                        IOUtil.close(in);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(in);
                    throw throwable;
                }
                IOUtil.close((InputStream)in);
            }
        }
        return version;
    }

    public static boolean hasFacesServlet(IFile webXml) {
        if (webXml == null || !webXml.isAccessible()) {
            return false;
        }
        InputStream is = null;
        try {
            is = webXml.getContents();
            boolean bl = JSFUtils.hasFacesServlet(is);
            return bl;
        }
        catch (Exception e) {
            LOG.error(NLS.bind((String)Messages.JSFUtils_Error_Finding_Faces_Servlet_In_WebXml, (Object)FACES_SERVLET, (Object)webXml.getLocation().toOSString()), (Throwable)e);
        }
        finally {
            IOUtil.close((InputStream)is);
        }
        return false;
    }

    public static boolean hasFacesServlet(InputStream input) {
        if (input == null) {
            return false;
        }
        boolean hasFacesServlet = false;
        try {
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setNamespaceAware(false);
            domFactory.setValidating(false);
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            Document doc = builder.parse(input);
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression expr = xpath.compile(FACES_SERVLET_XPATH);
            hasFacesServlet = expr.evaluate(doc, XPathConstants.NODE) != null;
        }
        catch (Exception e) {
            LOG.error(NLS.bind((String)Messages.JSFUtils_Error_Finding_Faces_Servlet, (Object)FACES_SERVLET), (Throwable)e);
        }
        return hasFacesServlet;
    }

    public static String getJSFVersionFromClasspath(IProject project) {
        String version = null;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            IType type = null;
            try {
                type = javaProject.findType("javax.faces.context.FacesContext");
            }
            catch (JavaModelException e) {
                LOG.error(Messages.JSFUtils_Error_Searching_For_JSF_Type, (Throwable)e);
            }
            if (type != null) {
                String[] emptyParams = new String[0];
                if (type.getMethod("getResourceLibraryContracts", emptyParams).exists()) {
                    return "2.2";
                }
                if (type.getMethod("isReleased", emptyParams).exists()) {
                    return "2.1";
                }
                if (type.getMethod("getAttributes", emptyParams).exists() && type.getMethod("getPartialViewContext", emptyParams).exists()) {
                    return "2.0";
                }
                if (type.getMethod("getELContext", emptyParams).exists()) {
                    return "1.2";
                }
                version = "1.1";
            }
        }
        return version;
    }

    public static IProjectFacetVersion getSafeJSFFacetVersion(String version) {
        IProjectFacetVersion facetVersion = null;
        if (version != null && version.trim().length() > 0) {
            try {
                facetVersion = MavenJSFConstants.JSF_FACET.getVersion(version);
            }
            catch (Exception e) {
                LOG.error(NLS.bind((String)Messages.JSFUtils_Error_Finding_JSF_Version, (Object)version), (Throwable)e);
                try {
                    facetVersion = MavenJSFConstants.JSF_FACET.getLatestVersion();
                }
                catch (CoreException cex) {
                    LOG.error(Messages.JSFUtils_Error_Finding_Latest_JSF_Version, (Throwable)cex);
                    facetVersion = MavenJSFConstants.JSF_FACET.getDefaultVersion();
                }
            }
        }
        return facetVersion;
    }
}

