/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.filtering;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectUtils;
import org.eclipse.m2e.wtp.EarPluginConfiguration;
import org.eclipse.m2e.wtp.ProjectUtils;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.internal.filtering.AbstractResourceFilteringConfiguration;

public class EarResourceFilteringConfiguration
extends AbstractResourceFilteringConfiguration {
    private EarPluginConfiguration earPluginConfiguration;

    public EarResourceFilteringConfiguration(IMavenProjectFacade mavenProjectFacade) {
        super(mavenProjectFacade);
        this.earPluginConfiguration = new EarPluginConfiguration(mavenProjectFacade.getMavenProject());
        this.pluginConfiguration = this.earPluginConfiguration;
    }

    @Override
    public IPath getTargetFolder() {
        return EarResourceFilteringConfiguration.getTargetFolder(this.mavenProjectFacade.getMavenProject(), this.mavenProjectFacade.getProject());
    }

    public static IPath getTargetFolder(MavenProject mavenProject, IProject project) {
        return ProjectUtils.getM2eclipseWtpFolder(mavenProject, project).append("ear-resources");
    }

    @Override
    public List<Xpp3Dom> getResources() {
        MavenProject mavenProject = this.mavenProjectFacade.getMavenProject();
        IProject project = this.mavenProjectFacade.getProject();
        IPath cliPackageDir = this.getCLIPackageDir(project, mavenProject.getBuild().getDirectory());
        ArrayList<Xpp3Dom> resources = new ArrayList<Xpp3Dom>();
        IPath targetClasses = WTPProjectsUtil.getClassesFolder(this.mavenProjectFacade).getLocation();
        for (Resource r : mavenProject.getResources()) {
            String targetPath = r.getTargetPath();
            if (targetPath == null || targetPath.trim().isEmpty()) continue;
            IPath originalTarget = Path.fromOSString((String)targetPath);
            if (!originalTarget.isAbsolute()) {
                originalTarget = targetClasses.append(originalTarget);
            }
            if (!cliPackageDir.isPrefixOf(originalTarget)) continue;
            Xpp3Dom resource = this.getAsXpp3Dom(r.getDirectory(), r.getFiltering(), originalTarget.makeRelativeTo(cliPackageDir).toPortableString(), r.getIncludes(), r.getExcludes());
            resources.add(resource);
        }
        if (this.earPluginConfiguration.isFilteringDeploymentDescriptorsEnabled()) {
            String earContentDir = this.earPluginConfiguration.getEarContentDirectory(project);
            Xpp3Dom resource = this.getAsXpp3Dom(earContentDir, Boolean.TRUE.toString(), null, null, null);
            resources.add(resource);
        }
        return resources;
    }

    private IPath getCLIPackageDir(IProject project, String targetDir) {
        IPath relativeTargetPath = MavenProjectUtils.getProjectRelativePath((IProject)project, (String)targetDir);
        if (relativeTargetPath == null) {
            return null;
        }
        Path fullTargetPath = new Path(targetDir);
        return fullTargetPath.append(this.earPluginConfiguration.getFinalName());
    }

    private Xpp3Dom getAsXpp3Dom(String folder, String filtering, String targetPath, List<String> inclusions, List<String> exclusions) {
        Xpp3Dom resource = new Xpp3Dom("resource");
        Xpp3Dom directory = new Xpp3Dom("directory");
        directory.setValue(folder);
        resource.addChild(directory);
        Xpp3Dom filter = new Xpp3Dom("filtering");
        filter.setValue(filtering);
        resource.addChild(filter);
        if (targetPath != null && !targetPath.isEmpty()) {
            Xpp3Dom targetPathDom = new Xpp3Dom("targetPath");
            targetPathDom.setValue(targetPath);
            resource.addChild(targetPathDom);
        }
        if (exclusions != null && !exclusions.isEmpty()) {
            Xpp3Dom exclusionsDom = new Xpp3Dom("excludes");
            for (String excl : exclusions) {
                Xpp3Dom exclusion = new Xpp3Dom("exclude");
                exclusion.setValue(excl);
                exclusionsDom.addChild(exclusion);
            }
            resource.addChild(exclusionsDom);
        }
        if (inclusions != null && !inclusions.isEmpty()) {
            Xpp3Dom inclusionsDom = new Xpp3Dom("includes");
            for (String incl : inclusions) {
                Xpp3Dom inclusion = new Xpp3Dom("include");
                inclusion.setValue(incl);
                inclusionsDom.addChild(inclusion);
            }
            resource.addChild(inclusionsDom);
        }
        return resource;
    }
}

