/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.target;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.m2e.pde.target.CacheManager;
import org.eclipse.pde.core.target.TargetBundle;

public class MavenSourceBundle
extends TargetBundle {
    public static final String ECLIPSE_SOURCE_BUNDLE_HEADER = "Eclipse-SourceBundle";

    public MavenSourceBundle(BundleInfo sourceTarget, Artifact artifact, CacheManager cacheManager) throws Exception {
        Manifest manifest;
        this.fSourceTarget = sourceTarget;
        this.fInfo.setSymbolicName(sourceTarget.getSymbolicName() + ".source");
        this.fInfo.setVersion(sourceTarget.getVersion());
        File sourceFile = artifact.getFile();
        Throwable throwable = null;
        Object var7_7 = null;
        try (JarFile jar = new JarFile(sourceFile);){
            manifest = Objects.requireNonNullElseGet(jar.getManifest(), Manifest::new);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (MavenSourceBundle.isValidSourceManifest(manifest)) {
            this.fInfo.setLocation(sourceFile.toURI());
        } else {
            File generatedSourceBundle = cacheManager.accessArtifactFile(artifact, file2 -> {
                if (CacheManager.isOutdated(file2, sourceFile)) {
                    this.addSourceBundleMetadata(manifest, sourceTarget);
                    this.transferJarEntries(sourceFile, manifest, file2);
                }
                return file2;
            });
            this.fInfo.setLocation(generatedSourceBundle.toURI());
        }
    }

    private void addSourceBundleMetadata(Manifest manifest, BundleInfo bundle) {
        Attributes attr = manifest.getMainAttributes();
        if (attr.isEmpty()) {
            attr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        attr.putValue(ECLIPSE_SOURCE_BUNDLE_HEADER, bundle.getSymbolicName() + ";version=\"" + bundle.getVersion() + "\";roots:=\".\"");
        attr.putValue("Bundle-ManifestVersion", "2");
        attr.putValue("Bundle-Name", "Source Bundle for " + bundle.getSymbolicName() + ":" + bundle.getVersion());
        attr.putValue("Bundle-SymbolicName", this.fInfo.getSymbolicName());
        attr.putValue("Bundle-Version", this.fInfo.getVersion());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void transferJarEntries(File source, Manifest manifest, File target) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            JarOutputStream output = new JarOutputStream((OutputStream)new FileOutputStream(target), manifest);
            try {
                try (JarInputStream input = new JarInputStream(new FileInputStream(source));){
                    JarEntry entry;
                    while ((entry = input.getNextJarEntry()) != null) {
                        if ("META-INF/MANIFEST.MF".equals(entry.getName())) continue;
                        output.putNextEntry(new ZipEntry(entry.getName()));
                        input.transferTo(output);
                    }
                }
                if (output == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (output == null) throw throwable;
                output.close();
                throw throwable;
            }
            output.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static boolean isValidSourceManifest(Manifest manifest) {
        return manifest != null && manifest.getMainAttributes().getValue(ECLIPSE_SOURCE_BUNDLE_HEADER) != null;
    }
}

