/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

@Component(service={URLStreamHandlerService.class}, property={"url.handler.protocol=mvn"})
public class MvnProtocolHandlerService
extends AbstractURLStreamHandlerService
implements DebugOptionsListener {
    private static final String ID = "org.eclipse.m2e.core";
    private static final String OPTION = "/mvnProtocolHandler";
    private final IMaven maven;
    private volatile DebugTrace debugTrace;
    private final ServiceRegistration<DebugOptionsListener> serviceRegistration;

    @Activate
    public MvnProtocolHandlerService(@Reference IMaven maven, BundleContext bundleContext) {
        this.maven = maven;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("listener.symbolic.name", ID);
        this.serviceRegistration = bundleContext.registerService(DebugOptionsListener.class, (Object)this, hashtable);
    }

    @Deactivate
    void shutdown() {
        this.serviceRegistration.unregister();
    }

    public void optionsChanged(DebugOptions options) {
        this.debugTrace = options.getBooleanOption("org.eclipse.m2e.core/mvnProtocolHandler", false) ? options.newDebugTrace(ID, MvnProtocolHandlerService.class) : null;
    }

    public URLConnection openConnection(URL url) {
        return new MavenURLConnection(url, this.maven, this.debugTrace);
    }

    private static final class MavenURLConnection
    extends URLConnection {
        private String subPath;
        private ArtifactResult artifactResult;
        private final IMaven maven;
        private final DebugTrace debugTrace;

        protected MavenURLConnection(URL url, IMaven maven, DebugTrace debugTrace) {
            super(url);
            this.maven = maven;
            this.debugTrace = debugTrace;
        }

        @Override
        public void connect() throws IOException {
            String[] coordinates;
            int subPathIndex;
            if (this.artifactResult != null) {
                return;
            }
            String path = this.url.getPath();
            if (path == null) {
                throw new IOException("maven coordinates are missing");
            }
            if (this.debugTrace != null) {
                this.debugTrace.trace(MvnProtocolHandlerService.OPTION, "connect to " + String.valueOf(this.url));
            }
            if ((subPathIndex = path.indexOf(47)) > -1) {
                this.subPath = path.substring(subPathIndex);
                coordinates = path.substring(0, subPathIndex).split(":");
            } else {
                coordinates = path.split(":");
            }
            if (coordinates.length < 3) {
                throw new IOException("required format is groupId:artifactId:version[:packaging[:classifier]]");
            }
            String type = coordinates.length > 3 ? coordinates[3] : "jar";
            String classifier = coordinates.length > 4 ? coordinates[4] : null;
            DefaultArtifact artifact = new DefaultArtifact(coordinates[0], coordinates[1], classifier, type, coordinates[2]);
            try {
                RepositorySystem repoSystem = this.maven.lookup(RepositorySystem.class);
                IMavenExecutionContext context = this.maven.createExecutionContext();
                boolean isSnapshot = artifact.getBaseVersion().endsWith("-SNAPSHOT");
                if (isSnapshot && !context.getExecutionRequest().isUpdateSnapshots()) {
                    context.getExecutionRequest().setUpdateSnapshots(true);
                }
                List<ArtifactRepository> artifactRepositories = this.maven.getArtifactRepositories();
                List remoteRepositories = RepositoryUtils.toRepos(artifactRepositories);
                if (this.debugTrace != null) {
                    this.debugTrace.trace(MvnProtocolHandlerService.OPTION, "Fetching artifact " + String.valueOf(artifact) + " using " + remoteRepositories.stream().map(rp -> rp.getUrl()).collect(Collectors.joining(", ")) + " with update snapshots = " + context.getExecutionRequest().isUpdateSnapshots());
                }
                this.artifactResult = context.execute(new ICallable<ArtifactResult>((Artifact)artifact, remoteRepositories, repoSystem){
                    private final /* synthetic */ Artifact val$artifact;
                    private final /* synthetic */ List val$remoteRepositories;
                    private final /* synthetic */ RepositorySystem val$repoSystem;
                    {
                        this.val$artifact = artifact;
                        this.val$remoteRepositories = list;
                        this.val$repoSystem = repositorySystem;
                    }

                    @Override
                    public ArtifactResult call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                        ArtifactRequest artifactRequest = new ArtifactRequest(this.val$artifact, this.val$remoteRepositories, null);
                        RepositorySystemSession session = context.getRepositorySession();
                        try {
                            return this.val$repoSystem.resolveArtifact(session, artifactRequest);
                        }
                        catch (ArtifactResolutionException e) {
                            if (debugTrace != null) {
                                debugTrace.trace(MvnProtocolHandlerService.OPTION, "resolving of artifact " + String.valueOf(this.val$artifact) + " failed!", (Throwable)e);
                            }
                            throw new CoreException(Status.error((String)"Resolving artifact failed", (Throwable)e));
                        }
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new IOException("resolving artifact " + String.valueOf(artifact) + " failed", e);
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            if (this.artifactResult == null || this.artifactResult.isMissing()) {
                throw new FileNotFoundException();
            }
            File location = this.artifactResult.getArtifact().getFile();
            if (this.subPath == null) {
                if (this.debugTrace != null) {
                    this.debugTrace.trace(MvnProtocolHandlerService.OPTION, "Open stream to artifact file " + String.valueOf(location));
                }
                return new FileInputStream(location);
            }
            String urlSpec = "jar:" + String.valueOf(location.toURI()) + "!" + this.subPath;
            try {
                if (this.debugTrace != null) {
                    this.debugTrace.trace(MvnProtocolHandlerService.OPTION, "Open stream to subpath in artifact file " + urlSpec);
                }
                return new URI(urlSpec).toURL().openStream();
            }
            catch (URISyntaxException ex) {
                throw new IOException(ex);
            }
        }

        @Override
        public long getLastModified() {
            try {
                this.connect();
            }
            catch (IOException e) {
                return 0L;
            }
            if (this.artifactResult == null || this.artifactResult.isMissing()) {
                return 0L;
            }
            return this.artifactResult.getArtifact().getFile().lastModified();
        }
    }
}

