/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.ui;

import java.util.List;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.generator.framework.Generator;
import org.eclipse.swtbot.generator.ui.BotGeneratorEventDispatcher;
import org.eclipse.swtbot.generator.ui.GeneratorExtensionPointManager;
import org.eclipse.swtbot.generator.ui.RecorderDialog;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;

public class StartupRecorder
implements IStartup {
    private static final String ENABLEMENT_PROPERTY = "org.eclipse.swtbot.generator.enable";

    public void earlyStartup() {
        if (!Boolean.parseBoolean(System.getProperty(ENABLEMENT_PROPERTY))) {
            return;
        }
        final List<Generator> availableGenerators = GeneratorExtensionPointManager.loadGenerators();
        Generator generator = availableGenerators.get(0);
        final BotGeneratorEventDispatcher dispatcher = new BotGeneratorEventDispatcher();
        dispatcher.setGenerator(generator);
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                display.addFilter(26, (Listener)dispatcher);
                display.addFilter(21, (Listener)dispatcher);
                display.addFilter(13, (Listener)dispatcher);
                display.addFilter(17, (Listener)dispatcher);
                display.addFilter(24, (Listener)dispatcher);
                Shell recorderShell = new Shell(PlatformUI.getWorkbench().getDisplay(), 2144);
                recorderShell.setText("SWTBot test recorder");
                dispatcher.ignoreShell(recorderShell);
                RecorderDialog recorderDialog = new RecorderDialog(recorderShell, dispatcher, availableGenerators);
                recorderDialog.open();
                recorderDialog.getShell().addShellListener((ShellListener)new ShellAdapter(){

                    public void shellClosed(ShellEvent e) {
                        display.removeFilter(26, (Listener)dispatcher);
                        display.removeFilter(21, (Listener)dispatcher);
                        display.removeFilter(3, (Listener)dispatcher);
                        display.removeFilter(8, (Listener)dispatcher);
                        display.removeFilter(4, (Listener)dispatcher);
                        display.removeFilter(1, (Listener)dispatcher);
                        display.removeFilter(13, (Listener)dispatcher);
                        display.removeFilter(17, (Listener)dispatcher);
                        display.removeFilter(24, (Listener)dispatcher);
                    }
                });
            }
        });
    }
}

