/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.framework.rules;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swtbot.generator.framework.GenerationRule;

public class MenuClickedRule
extends GenerationRule {
    private MenuItem item;

    public boolean appliesTo(Event event) {
        return event.type == 13 && event.widget instanceof MenuItem;
    }

    public void initializeForEvent(Event event) {
        this.item = (MenuItem)event.widget;
    }

    protected String getWidgetAccessor() {
        StringBuilder code = new StringBuilder();
        ArrayList<String> path = new ArrayList<String>();
        path.add(MenuClickedRule.cleanMenuText(this.item.getText()));
        MenuItem currentItem = this.item;
        Menu parent = null;
        while (currentItem != null && (parent = currentItem.getParent()) != null) {
            currentItem = parent.getParentItem();
            if (currentItem == null || currentItem.getText() == null) continue;
            path.add(MenuClickedRule.cleanMenuText(currentItem.getText()));
        }
        Collections.reverse(path);
        code.append("bot");
        for (String text : path) {
            code.append(".menu(\"");
            code.append(text);
            code.append("\")");
        }
        return code.toString();
    }

    private static String cleanMenuText(String text) {
        return text.replace("&", "").split("\t")[0];
    }

    protected String getActon() {
        return ".click()";
    }
}

