/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.jdt.editor;

import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtbot.generator.jdt.editor.document.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddMethodDialog
extends TitleAreaDialog {
    private String title;
    private String methodName;
    private Text methodText;
    private List<Method> methods;

    public AddMethodDialog(Shell shell, List<Method> methods) {
        super(shell);
        this.methods = methods;
        this.setShellStyle(0xC70 | AddMethodDialog.getDefaultOrientation());
        this.title = "Add new method";
    }

    protected Control createDialogArea(Composite parent) {
        this.setHelpAvailable(false);
        this.getShell().setText(this.title);
        this.setTitle(this.title);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridData gridData = new GridData(1808);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)gridData);
        Label methodLabel = new Label(container, 0);
        methodLabel.setText("Method name:");
        GridData dataMethodText = new GridData();
        dataMethodText.grabExcessHorizontalSpace = true;
        dataMethodText.horizontalAlignment = 4;
        this.methodText = new Text(container, 2052);
        this.methodText.setLayoutData((Object)dataMethodText);
        this.methodText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                for (Method m : AddMethodDialog.this.methods) {
                    if (!m.getName().equals(AddMethodDialog.this.methodText.getText())) continue;
                    AddMethodDialog.this.getButton(0).setEnabled(false);
                    AddMethodDialog.this.setMessage("Method " + AddMethodDialog.this.methodText.getText() + " already exists!", 2);
                    return;
                }
                if (!AddMethodDialog.this.methodText.getText().isEmpty() && !AddMethodDialog.this.methodText.getText().contains(" ")) {
                    AddMethodDialog.this.getButton(0).setEnabled(true);
                    AddMethodDialog.this.setMessage("");
                } else {
                    AddMethodDialog.this.getButton(0).setEnabled(false);
                    AddMethodDialog.this.setMessage("Method name " + AddMethodDialog.this.methodText.getText() + " is invalid!", 2);
                }
            }
        });
        return this.getShell();
    }

    public String getMethodName() {
        return this.methodName;
    }

    protected void okPressed() {
        this.methodName = this.methodText.getText();
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(300, 200);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }
}

