/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.Object;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.ASN1Object;
import org.eclipse.titan.designer.AST.ASN1.Block;
import org.eclipse.titan.designer.AST.ASN1.Object.FieldSetting;
import org.eclipse.titan.designer.AST.ASN1.Object.FieldSetting_Value;
import org.eclipse.titan.designer.AST.ASN1.Object.FieldSpecification;
import org.eclipse.titan.designer.AST.ASN1.Object.FieldSpecifications;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectClassSyntax_Parser;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectClassSyntax_root;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISetting;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.compiler.BuildTimestamp;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Object_Definition
extends ASN1Object {
    private static final String DUPLICATEDFIELDSETTINGFIRST = "Duplicate field setting with name `{0}'' was first declared here";
    private static final String DUPLICATEDFIELDSETTINGREPEATED = "Duplicate field setting with name `{0}'' was declared here again";
    private static final String MISSINGFIELDSETTINGWITHNAME = "No field setting with identifier `{0}'' in object `{1}''";
    private static final String MISSINGSETTINGORDEFAULT = "No field setting or default with identifier `{0}'' in object `'{1}'";
    private final Block mBlock;
    private final ArrayList<FieldSetting> fieldSettings;
    private HashMap<String, FieldSetting> fieldSettingMap;
    private BuildTimestamp lastTimeGenerated = null;

    public Object_Definition(Block aBlock) {
        this.mBlock = aBlock;
        if (null != aBlock && aBlock.getTokenListSize() >= 0) {
            this.location = new Location(aBlock.getLocation());
        }
        this.fieldSettings = new ArrayList();
    }

    @Override
    public Object_Definition newInstance() {
        Object_Definition temp = null;
        temp = new Object_Definition(this.mBlock);
        for (int i = 0; i < this.fieldSettings.size(); ++i) {
            temp.addFieldSetting(this.fieldSettings.get(i).newInstance());
        }
        return temp;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        for (int i = 0; i < this.fieldSettings.size(); ++i) {
            FieldSetting fieldSetting = this.fieldSettings.get(i);
            if (fieldSetting != child) continue;
            return builder.append(".").append(fieldSetting.getName().getDisplayName());
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.fieldSettings.trimToSize();
        for (int i = 0; i < this.fieldSettings.size(); ++i) {
            this.fieldSettings.get(i).setMyScope(scope);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (null == this.fieldSettingMap) {
            this.fieldSettingMap = new HashMap(this.fieldSettings.size());
        }
        this.fieldSettingMap.clear();
        if (null != this.myGovernor) {
            this.myGovernor.check(timestamp);
        }
        this.parseBlock(timestamp);
        for (int i = 0; i < this.fieldSettings.size(); ++i) {
            FieldSetting fieldSetting = this.fieldSettings.get(i);
            String name = fieldSetting.getName().getName();
            if (this.fieldSettingMap.containsKey(name)) {
                Location location = this.fieldSettingMap.get(name).getLocation();
                location.reportSingularSemanticError(MessageFormat.format(DUPLICATEDFIELDSETTINGFIRST, fieldSetting.getName().getDisplayName()));
                fieldSetting.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEDFIELDSETTINGREPEATED, fieldSetting.getName().getDisplayName()));
                continue;
            }
            this.fieldSettingMap.put(name, fieldSetting);
        }
        this.fieldSettings.trimToSize();
        if (null != this.myGovernor) {
            this.myGovernor.checkThisObject(timestamp, this);
        }
    }

    public void addFieldSetting(FieldSetting fieldSetting) {
        if (null != fieldSetting && null != fieldSetting.getName() && null != fieldSetting.getLocation()) {
            this.fieldSettings.add(fieldSetting);
            fieldSetting.setMyScope(this.myScope);
            fieldSetting.setFullNameParent(this);
        }
    }

    public int getNofFieldSettings() {
        return this.fieldSettings.size();
    }

    public boolean hasFieldSettingWithName(Identifier identifier) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.fieldSettingMap.containsKey(identifier.getName());
    }

    public FieldSetting getFieldSettingByName(Identifier identifier) {
        String name;
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        if (this.fieldSettingMap.containsKey(name = identifier.getName())) {
            return this.fieldSettingMap.get(name);
        }
        if (!this.isErroneous) {
            this.location.reportSemanticError(MessageFormat.format(MISSINGFIELDSETTINGWITHNAME, identifier.getDisplayName(), this.getFullName()));
        }
        return null;
    }

    public boolean hasFieldSettingWithNameDefault(Identifier identifier) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        if (this.fieldSettingMap.containsKey(identifier.getName())) {
            return true;
        }
        return this.myGovernor.getFieldSpecifications().hasFieldSpecificationWithId(identifier) && this.myGovernor.getFieldSpecifications().getFieldSpecificationByIdentifier(identifier).hasDefault();
    }

    public ISetting getSettingByNameDefault(Identifier identifier) {
        FieldSpecification fs;
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        if (this.fieldSettingMap.containsKey(identifier.getName())) {
            return this.fieldSettingMap.get(identifier.getName()).getSetting();
        }
        FieldSpecifications governorFieldspecs = this.myGovernor.getFieldSpecifications();
        if (governorFieldspecs.hasFieldSpecificationWithId(identifier) && (fs = governorFieldspecs.getFieldSpecificationByIdentifier(identifier)).hasDefault()) {
            return fs.getDefault();
        }
        if (!this.isErroneous) {
            this.location.reportSemanticError(MessageFormat.format(MISSINGSETTINGORDEFAULT, identifier.getDisplayName(), this.getFullName()));
        }
        return null;
    }

    public FieldSetting getFieldSettingWithNameDefault(Identifier identifier, boolean reportError) {
        FieldSpecification fs;
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        if (this.fieldSettingMap.containsKey(identifier.getName())) {
            return this.fieldSettingMap.get(identifier.getName());
        }
        if (this.myGovernor.getFieldSpecifications().hasFieldSpecificationWithId(identifier) && (fs = this.myGovernor.getFieldSpecifications().getFieldSpecificationByIdentifier(identifier)).hasDefault()) {
            return (FieldSetting)((Object)fs.getDefault());
        }
        if (reportError && !this.isErroneous) {
            this.location.reportSemanticError(MessageFormat.format(MISSINGSETTINGORDEFAULT, identifier.getDisplayName(), this.getFullName()));
        }
        return null;
    }

    public IValue getUniqueFieldSettingValue() {
        FieldSpecification uniqueFieldSpec;
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        if ((uniqueFieldSpec = this.myGovernor.getFieldSpecifications().getUnique()) == null) {
            return null;
        }
        FieldSetting fieldSetting = this.getFieldSettingByName(uniqueFieldSpec.getIdentifier());
        if (fieldSetting != null && fieldSetting instanceof FieldSetting_Value) {
            return ((FieldSetting_Value)fieldSetting).getSetting();
        }
        return null;
    }

    public FieldSetting getFieldSettingWithNameDefault(Identifier identifier) {
        return this.getFieldSettingWithNameDefault(identifier, true);
    }

    @Override
    public Object_Definition getRefdLast(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        return this;
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int index) {
        List<ISubReference> subreferences = propCollector.getReference().getSubreferences();
        if (subreferences.size() <= index) {
            return;
        }
        ISubReference subreference = subreferences.get(index);
        String subreferenceName = subreference.getId().getName();
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
            if (subreferences.size() > index + 1) {
                FieldSetting fieldSetting = this.fieldSettingMap.get(subreferenceName);
                if (null == fieldSetting) {
                    return;
                }
                fieldSetting.addProposal(propCollector, index + 1);
            } else {
                for (int j = 0; j < this.fieldSettings.size(); ++j) {
                    FieldSetting fieldSetting = this.fieldSettings.get(index);
                    if (!fieldSetting.getName().getName().startsWith(subreferenceName)) continue;
                    propCollector.addProposal(fieldSetting.getName(), "- Object field", null, "FieldSetting");
                }
            }
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int index) {
        List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
        if (subreferences.size() <= index) {
            return;
        }
        ISubReference subreference = subreferences.get(index);
        String subreferenceName = subreference.getId().getName();
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
            if (subreferences.size() > index + 1) {
                FieldSetting fieldSetting = this.fieldSettingMap.get(subreferenceName);
                if (null == fieldSetting) {
                    return;
                }
                fieldSetting.addDeclaration(declarationCollector, index + 1);
            } else {
                for (int j = 0; j < this.fieldSettings.size(); ++j) {
                    FieldSetting fieldSetting = this.fieldSettings.get(index);
                    String name = fieldSetting.getName().getName();
                    if (!name.startsWith(subreferenceName)) continue;
                    declarationCollector.addDeclaration(name, fieldSetting.getLocation(), this);
                }
            }
        }
    }

    protected void parseBlock(CompilationTimeStamp timestamp) {
        if (null == this.mBlock || null == this.myGovernor) {
            return;
        }
        ObjectClassSyntax_Parser parser = new ObjectClassSyntax_Parser(this.mBlock, this);
        ObjectClassSyntax_root root = this.myGovernor.getObjectClassSyntax(timestamp);
        this.fieldSettings.clear();
        if (null != root) {
            root.accept(parser);
        }
    }

    @Override
    public boolean memberAccept(ASTVisitor v) {
        if (this.fieldSettings != null) {
            for (FieldSetting fs : this.fieldSettings) {
                if (fs.accept(v)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void generateCode(JavaGenData aData) {
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        for (FieldSetting fs : this.fieldSettings) {
            fs.generateCode(aData);
        }
    }
}

