/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.definitions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.titan.designer.AST.ASN1.ASN1Assignments;
import org.eclipse.titan.designer.AST.ASN1.Defined_Reference;
import org.eclipse.titan.designer.AST.ASN1.definitions.Exports;
import org.eclipse.titan.designer.AST.ASN1.definitions.ImportModule;
import org.eclipse.titan.designer.AST.ASN1.definitions.Imports;
import org.eclipse.titan.designer.AST.ASN1.definitions.Tag_types;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Assignments;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ModuleImportationChain;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.parsers.ProjectStructureDataCollector;
import org.eclipse.ui.IEditorPart;

public final class ASN1Module
extends Module {
    private static final String FULLNAMEPART1 = ".<exports>";
    private static final String FULLNAMEPART2 = ".<imports>";
    private static final String NOASSIGNMENT = "There is no assignment with name `{0}'' in module `{1}''";
    public static final String NOASSIGNMENTORSYMBOL = "There is no assignment or imported symbol with name `{0}'' in module `{1}''";
    private static final String MORESYMBOLS = "There are more imported symbols with name `{0}'' in module `{1}''";
    private static final String NOIMPORTEDMODULE = "There is no imported module with name `{0}''";
    private static final String NOSYMBOLSIMPORTED = "There is no symbol with name `{0}'' imported from module `{1}''";
    private final Tag_types tagdef;
    private final boolean extensibilityImplied;
    private Exports exports;
    private Imports imports;
    private ASN1Assignments assignments;
    private boolean needsTobeBuilt = true;

    public ASN1Module(Identifier identifier, IProject project, Tag_types tagdef, boolean extensibilityImplied) {
        super(identifier, project);
        this.tagdef = tagdef;
        this.extensibilityImplied = extensibilityImplied;
        this.exports = new Exports(false);
        this.exports.setMyModule(this);
        this.exports.setFullNameParent(this);
        this.imports = new Imports();
        this.imports.setMyModule(this);
        this.imports.setFullNameParent(this);
        this.assignments = new ASN1Assignments();
        this.assignments.setParentScope(this);
        this.assignments.setFullNameParent(this);
    }

    @Override
    public Module.module_type getModuletype() {
        return Module.module_type.ASN_MODULE;
    }

    public void setExports(Exports exports) {
        this.exports = exports;
        this.exports.setMyModule(this);
        exports.setFullNameParent(this);
    }

    public void setImports(Imports imports) {
        this.imports = imports;
        this.imports.setMyModule(this);
        imports.setProject(this.project);
        imports.setFullNameParent(this);
    }

    public void setAssignments(ASN1Assignments assignments) {
        this.assignments = assignments;
        this.assignments.setParentScope(this);
        this.addSubScope(assignments.getLocation(), assignments);
        assignments.setFullNameParent(this);
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = new StringBuilder();
        builder.append("@").append(this.getIdentifier().getDisplayName());
        if (this.exports == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.imports == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public Assignments getAssignmentsScope() {
        return this.assignments;
    }

    @Override
    public Def_Type getAnytype() {
        return null;
    }

    @Override
    public Object[] getOutlineChildren() {
        return new Object[]{this.imports, this.assignments};
    }

    @Override
    public String getOutlineText() {
        return "";
    }

    @Override
    public String getOutlineIcon() {
        return "asn.gif";
    }

    public boolean hasImportedAssignmentWithId(Identifier identifier) {
        return this.imports.hasImportedSymbolWithId(identifier);
    }

    @Override
    public void checkImports(CompilationTimeStamp timestamp, ModuleImportationChain referenceChain, List<Module> moduleStack) {
        if (null != this.lastImportCheckTimeStamp && !this.lastImportCheckTimeStamp.isLess(timestamp)) {
            return;
        }
        this.assignments.checkUniqueness(timestamp);
        this.imports.checkImports(timestamp, referenceChain, moduleStack);
        this.exports.check(timestamp);
        this.lastImportCheckTimeStamp = timestamp;
    }

    @Override
    public Assignment importAssignment(CompilationTimeStamp timestamp, Identifier moduleId, Reference reference) {
        Identifier id = reference.getId();
        return this.assignments.getLocalAssignmentByID(timestamp, id);
    }

    @Override
    public boolean isVisible(CompilationTimeStamp timestamp, Identifier moduleId, Assignment assignment) {
        return true;
    }

    @Override
    public List<Module> getImportedModules() {
        return this.imports.getImportedModules();
    }

    @Override
    public boolean hasUnhandledImportChanges() {
        return this.imports.hasUnhandledImportChanges();
    }

    @Override
    public void postCheck() {
        this.assignments.postCheck();
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (null != this.lastCompilationTimeStamp && !this.lastCompilationTimeStamp.isLess(timestamp)) {
            return;
        }
        this.lastCompilationTimeStamp = timestamp;
        this.needsTobeBuilt = true;
        if (!"<internal_module>".equals(this.identifier.getAsnName())) {
            NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionASN1Module", this.identifier, "ASN.1 module");
        }
        this.imports.check(timestamp);
        this.assignments.check(timestamp);
    }

    @Override
    public Assignments getAssignments() {
        return this.assignments;
    }

    public boolean exportsSymbol(CompilationTimeStamp timestamp, Identifier identifier) {
        return this.exports.exportsSymbol(timestamp, identifier);
    }

    @Override
    public boolean hasImportedAssignmentWithID(CompilationTimeStamp timestamp, Identifier identifier) {
        return this.imports.singularImportedSymbols_map.containsKey(identifier.getName());
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference) {
        return this.getAssBySRef(timestamp, reference, null);
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference, IReferenceChain refChain) {
        Identifier moduleId = reference.getModuleIdentifier();
        Identifier id = reference.getId();
        if (null == id) {
            return null;
        }
        Module module = null;
        if (null == moduleId || moduleId.getName().equals(this.identifier.getName())) {
            if (this.assignments.hasLocalAssignmentWithID(timestamp, id)) {
                return this.assignments.getLocalAssignmentByID(timestamp, id);
            }
            if (null != moduleId) {
                id.getLocation().reportSemanticError(MessageFormat.format(NOASSIGNMENT, id.getDisplayName(), this.identifier.getDisplayName()));
                return null;
            }
            if (this.imports.singularImportedSymbols_map.containsKey(id.getName())) {
                module = this.imports.singularImportedSymbols_map.get(id.getName());
                moduleId = module.getIdentifier();
                this.imports.getImportedModuleById(moduleId).setUsedForImportation();
            } else {
                if (this.imports.pluralImportedSymbols.contains(id.getName())) {
                    id.getLocation().reportSemanticError(MessageFormat.format(MORESYMBOLS, id.getDisplayName(), this.identifier.getDisplayName()));
                    return null;
                }
                id.getLocation().reportSemanticError(MessageFormat.format(NOASSIGNMENTORSYMBOL, id.getDisplayName(), this.identifier.getDisplayName()));
                return null;
            }
        }
        if (null == module) {
            if (!this.imports.hasImportedModuleWithId(moduleId)) {
                moduleId.getLocation().reportSemanticError(MessageFormat.format(NOIMPORTEDMODULE, moduleId.getDisplayName()));
                return null;
            }
            if (!this.imports.getImportedModuleById(moduleId).hasSymbol(id)) {
                id.getLocation().reportSemanticError(MessageFormat.format(NOSYMBOLSIMPORTED, id.getDisplayName(), moduleId.getDisplayName()));
                return null;
            }
            this.imports.getImportedModuleById(moduleId).setUsedForImportation();
            ProjectSourceParser parser = GlobalParser.getProjectSourceParser(this.project);
            if (null == parser) {
                return null;
            }
            module = parser.getModuleByName(moduleId.getName());
        }
        if (this == module || null == module) {
            return null;
        }
        ArrayList<ISubReference> newSubreferences = new ArrayList<ISubReference>();
        newSubreferences.add(new FieldSubReference(id));
        Defined_Reference finalReference = new Defined_Reference(null, newSubreferences);
        return module.getAssBySRef(timestamp, finalReference);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("module: ").append(this.name);
        return builder.toString();
    }

    @Override
    public void addProposal(ProposalCollector propCollector) {
        ImportModule importation;
        Identifier moduleId = propCollector.getReference().getModuleIdentifier();
        if (null == moduleId) {
            this.imports.addProposal(propCollector);
        } else if (null != this.identifier && moduleId.getName().equals(this.identifier.getName())) {
            for (int i = 0; i < this.assignments.getNofAssignments(); ++i) {
                this.assignments.getAssignmentByIndex(i).addProposal(propCollector, 0);
            }
        } else if (this.imports.hasImportedModuleWithId(moduleId) && null != (importation = this.imports.getImportedModuleById(moduleId))) {
            importation.addProposal(propCollector, this.identifier);
        }
        super.addProposal(propCollector);
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector) {
        ImportModule importation;
        Identifier moduleId = declarationCollector.getReference().getModuleIdentifier();
        if (null == moduleId) {
            List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
            if (1 == subrefs.size() && null != this.identifier && this.identifier.getName().equals(subrefs.get(0).getId().getName())) {
                declarationCollector.addDeclaration(this.name, this.identifier.getLocation(), this);
            }
            this.imports.addDeclaration(declarationCollector);
        } else if (null != this.identifier && moduleId.getName().equals(this.identifier.getName())) {
            for (int i = 0; i < this.assignments.getNofAssignments(); ++i) {
                this.assignments.getAssignmentByIndex(i).addDeclaration(declarationCollector, 0);
            }
        } else if (this.imports.hasImportedModuleWithId(moduleId) && null != (importation = this.imports.getImportedModuleById(moduleId))) {
            importation.addDeclaration(declarationCollector, this.identifier);
        }
        super.addDeclaration(declarationCollector);
    }

    @Override
    public void extractStructuralInformation(ProjectStructureDataCollector collector) {
        this.imports.extractStructuralInformation(this.identifier, collector);
    }

    @Override
    public Assignment getEnclosingAssignment(int offset) {
        if (this.assignments == null) {
            return null;
        }
        return this.assignments.getEnclosingAssignment(offset);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.assignments != null) {
            this.assignments.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.exports != null && !this.exports.accept(v)) {
            return false;
        }
        if (this.imports != null && !this.imports.accept(v)) {
            return false;
        }
        return this.assignments == null || this.assignments.accept(v);
    }

    @Override
    public boolean shouldBeGenerated() {
        return this.needsTobeBuilt;
    }

    @Override
    public void generateCode(JavaGenData aData) {
        this.needsTobeBuilt = false;
        aData.addBuiltinTypeImport("TTCN_Module");
        this.imports.generateCode(aData);
        aData.getClassHeader().append(MessageFormat.format("public final class {0} extends TTCN_Module '{'\n", this.name));
        StringBuilder constructor = aData.getConstructor();
        constructor.append(MessageFormat.format("\tpublic {0}() '{'\n", this.identifier.getName()));
        constructor.append(MessageFormat.format("\t\tsuper(\"{0}\", module_type_enum.ASN1_MODULE, null);\n", this.identifier.getDisplayName()));
        constructor.append("\t}\n\n");
        if (this.assignments != null) {
            this.assignments.generateCode(aData);
        }
    }

    @Override
    public Ttcn3HoverContent getHoverContent(IEditorPart editor) {
        super.getHoverContent(editor);
        this.hoverContent.addIcon(this.getOutlineIcon());
        this.hoverContent.addText("module").addText(" ").addStyledText(this.identifier.getDisplayName(), 1);
        this.hoverContent.closeHeader();
        this.hoverContent.addContent(HoverContentType.INFO);
        return this.hoverContent;
    }
}

