/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuard;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.Catch_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Getreply_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Operation_Altguard;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.types.PortTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TypeSet;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Call_Statement
extends Statement {
    private static final String SENDONPORT = "Procedure-based operation `call'' is not applicable to a message-based port of type `{0}''";
    private static final String UNKNOWNSIGNATURE = "Cannot determine the type of the signature";
    private static final String TYPENOTPRESENT = "Signature type `{0}'' is not present on the outgoing list of port type `{1}''";
    private static final String NOOUTGOINGSIGNATURETYPES = "Port type `{0}'' does not have any outgoing signature types";
    private static final String CALLPARAMETERNOTSIGNATURE = "The type of call parameter is `{0}'' type, which is not a signature";
    private static final String NONBLOCKINGWITHTIMER = "A call of a non-blocking signature `{0}'' cannot have a call timer";
    private static final String NONBLOCKINGWITHNOWAIT = "A call of a non-blocking signature `{0}'' cannot use the `nowait'' keyword";
    private static final String NONBLOCKINGWITHRESPONSEPART = "A call of a non-blocking signature `{0}'' cannot have response and exception handling part";
    private static final String NOWAITWITHRESPONSEPART = "A call with `nowait' keyword cannot have response and exception handling part";
    private static final String RESPONSEPARTMISSING = "Response and exception handling part is missing from blocking call operation";
    private static final String CALLTIMERNEGATIVE = "The call timer has negative duration: `{0}''";
    private static final String FLOATTIMEREXPECTED = "The timer operand of the `call' operation should be a float value";
    private static final String GETRPELYTOWRONGSIGNATURE = "The `getreply'' operation refers to a different signature than the previous `call'' statement: `{0}'' was expected instead of `{1}''";
    private static final String FULLNAMEPART1 = ".port_reference";
    private static final String FULLNAMEPART2 = ".call_parameter";
    private static final String FULLNAMEPART3 = ".timer";
    private static final String FULLNAMEPART4 = ".to";
    private static final String FULLNAMEPART5 = ".body";
    private static final String FULLNAMEPART6 = ".redirectTimestamp";
    private static final String STATEMENT_NAME = "call";
    private final Reference portReference;
    private final TemplateInstance parameter;
    private final Value timerValue;
    private final boolean noWait;
    private final IValue toClause;
    private final Reference redirectTimestamp;
    private final AltGuards altGuards;

    public Call_Statement(Reference portReference, TemplateInstance parameter, Value timerValue, boolean noWait, IValue toClause, AltGuards altGuards, Reference redirectTimestamp) {
        this.portReference = portReference;
        this.parameter = parameter;
        this.timerValue = timerValue;
        this.noWait = noWait;
        this.toClause = toClause;
        this.altGuards = altGuards;
        this.redirectTimestamp = redirectTimestamp;
        if (portReference != null) {
            portReference.setFullNameParent(this);
        }
        if (parameter != null) {
            parameter.setFullNameParent(this);
        }
        if (timerValue != null) {
            timerValue.setFullNameParent(this);
        }
        if (toClause != null) {
            toClause.setFullNameParent(this);
        }
        if (altGuards != null) {
            altGuards.setFullNameParent(this);
        }
        if (redirectTimestamp != null) {
            redirectTimestamp.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_CALL;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.portReference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.parameter == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.timerValue == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.toClause == child) {
            return builder.append(FULLNAMEPART4);
        }
        if (this.altGuards == child) {
            return builder.append(FULLNAMEPART5);
        }
        if (this.toClause == child) {
            return builder.append(FULLNAMEPART6);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.portReference != null) {
            this.portReference.setMyScope(scope);
        }
        if (this.parameter != null) {
            this.parameter.setMyScope(scope);
        }
        if (this.timerValue != null) {
            this.timerValue.setMyScope(scope);
        }
        if (this.toClause != null) {
            this.toClause.setMyScope(scope);
        }
        if (this.altGuards != null) {
            this.altGuards.setMyScope(scope);
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.portReference != null) {
            this.portReference.setCodeSection(codeSection);
        }
        if (this.parameter != null) {
            this.parameter.setCodeSection(codeSection);
        }
        if (this.timerValue != null) {
            this.timerValue.setCodeSection(codeSection);
        }
        if (this.toClause != null) {
            this.toClause.setCodeSection(codeSection);
        }
        if (this.altGuards != null) {
            this.altGuards.setCodeSection(codeSection);
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.setCodeSection(codeSection);
        }
    }

    @Override
    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        super.setMyStatementBlock(statementBlock, index);
        if (this.altGuards != null) {
            this.altGuards.setMyStatementBlock(statementBlock, index);
        }
    }

    @Override
    public void setMyDefinition(Definition definition) {
        if (this.altGuards != null) {
            this.altGuards.setMyDefinition(definition);
        }
    }

    @Override
    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        if (this.altGuards != null) {
            this.altGuards.hasReturn(timestamp);
        }
        return StatementBlock.ReturnStatus_type.RS_NO;
    }

    @Override
    public boolean hasReceivingStatement() {
        if (this.altGuards != null) {
            return this.altGuards.hasReceivingStatement();
        }
        return false;
    }

    @Override
    protected void setMyLaicStmt(AltGuards pAltGuards, Statement pLoopStatement) {
        if (pLoopStatement != null && this.altGuards != null) {
            this.altGuards.setMyLaicStmt(null, pLoopStatement);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        Port_Type portType = Port_Utility.checkPortReference(timestamp, this, this.portReference, false);
        if (this.parameter == null) {
            return;
        }
        IType signatureType = null;
        boolean signatureTypeDetermined = false;
        if (portType != null) {
            PortTypeBody portTypeBody = portType.getPortBody();
            TypeSet outSignatures = portTypeBody.getOutSignatures();
            if (PortTypeBody.OperationModes.OP_Message.equals((Object)portTypeBody.getOperationMode())) {
                this.portReference.getLocation().reportSemanticError(MessageFormat.format(SENDONPORT, portType.getTypename()));
            } else if (outSignatures != null) {
                if (outSignatures.getNofTypes() == 1) {
                    signatureType = outSignatures.getTypeByIndex(0);
                } else {
                    signatureType = Port_Utility.getOutgoingType(timestamp, this.parameter);
                    if (signatureType == null) {
                        this.parameter.getLocation().reportSemanticError(UNKNOWNSIGNATURE);
                    } else if (!outSignatures.hasType(timestamp, signatureType)) {
                        this.parameter.getLocation().reportSemanticError(MessageFormat.format(TYPENOTPRESENT, signatureType.getTypename(), portType.getTypename()));
                    }
                }
                signatureTypeDetermined = true;
            } else {
                this.portReference.getLocation().reportSemanticError(MessageFormat.format(NOOUTGOINGSIGNATURETYPES, portType.getTypename()));
            }
        }
        if (!signatureTypeDetermined) {
            signatureType = Port_Utility.getOutgoingType(timestamp, this.parameter);
        }
        boolean isNonblocking = false;
        if (signatureType != null) {
            this.parameter.check(timestamp, signatureType);
            signatureType = signatureType.getTypeRefdLast(timestamp);
            switch (signatureType.getTypetype()) {
                case TYPE_SIGNATURE: {
                    ((Signature_Type)signatureType).checkThisTemplate(timestamp, this.parameter.getTemplateBody(), false, false, null);
                    isNonblocking = ((Signature_Type)signatureType).isNonblocking();
                    break;
                }
                default: {
                    this.parameter.getLocation().reportSemanticError(MessageFormat.format(CALLPARAMETERNOTSIGNATURE, signatureType.getTypename()));
                }
            }
            if (isNonblocking) {
                if (this.timerValue != null) {
                    this.timerValue.getLocation().reportSemanticError(MessageFormat.format(NONBLOCKINGWITHTIMER, signatureType.getTypename()));
                } else if (this.noWait) {
                    this.location.reportSemanticError(MessageFormat.format(NONBLOCKINGWITHNOWAIT, signatureType.getTypename()));
                }
                if (this.altGuards != null) {
                    this.location.reportSemanticError(MessageFormat.format(NONBLOCKINGWITHRESPONSEPART, signatureType.getTypename()));
                }
            } else if (this.noWait) {
                if (this.altGuards != null) {
                    this.location.reportSemanticError(NOWAITWITHRESPONSEPART);
                }
            } else if (!this.getIsErroneous() && this.altGuards == null) {
                this.location.reportSemanticError(RESPONSEPARTMISSING);
            }
        }
        if (this.timerValue != null) {
            this.timerValue.setLoweridToReference(timestamp);
            IType.Type_type temporalType = this.timerValue.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            switch (temporalType) {
                case TYPE_REAL: {
                    double temp;
                    IValue last = this.timerValue.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
                    if (!IValue.Value_type.REAL_VALUE.equals((Object)last.getValuetype()) || last.getIsErroneous(timestamp) || !((temp = ((Real_Value)last).getValue()) < 0.0)) break;
                    this.timerValue.getLocation().reportSemanticError(MessageFormat.format(CALLTIMERNEGATIVE, temp));
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous();
                    break;
                }
                default: {
                    if (this.isErroneous) break;
                    this.location.reportSemanticError(FLOATTIMEREXPECTED);
                }
            }
        }
        Port_Utility.checkToClause(timestamp, this, portType, this.toClause);
        Port_Utility.checkTimestampRedirect(timestamp, portType, this.redirectTimestamp);
        if (this.altGuards != null) {
            this.checkCallBody(timestamp, portType, signatureType);
        }
        this.lastTimeChecked = timestamp;
    }

    private void checkCallBody(CompilationTimeStamp timestamp, Port_Type portType, IType signature) {
        Statement statement;
        int i;
        boolean hasCatchTimeout = false;
        for (i = 0; i < this.altGuards.getNofAltguards(); ++i) {
            AltGuard altGuard = this.altGuards.getAltguardByIndex(i);
            if (!AltGuard.altguard_type.AG_OP.equals((Object)altGuard.getType()) || !Statement.Statement_type.S_CATCH.equals((Object)(statement = ((Operation_Altguard)altGuard).getGuardStatement()).getType())) continue;
            ((Catch_Statement)statement).setCallSettings(true, this.timerValue != null);
            hasCatchTimeout |= ((Catch_Statement)statement).hasTimeout();
        }
        this.altGuards.setMyLaicStmt(this.altGuards, null);
        this.altGuards.setMyAltguards(this.altGuards);
        this.altGuards.check(timestamp);
        if (portType != null) {
            block5: for (i = 0; i < this.altGuards.getNofAltguards(); ++i) {
                AltGuard altguard = this.altGuards.getAltguardByIndex(i);
                if (!AltGuard.altguard_type.AG_OP.equals((Object)altguard.getType()) || (statement = ((Operation_Altguard)altguard).getGuardStatement()).getIsErroneous()) continue;
                switch (statement.getType()) {
                    case S_GETREPLY: {
                        IType tempSignature;
                        String message;
                        Reference tempPortReference = ((Getreply_Statement)statement).getPortReference();
                        if (tempPortReference == null) {
                            message = MessageFormat.format("The `{0}'' operation must refer to the same port as the previous `call'' statement: `{1}'' was expected instead of `any port''", statement.getStatementName(), this.portReference.getId().getDisplayName());
                            statement.getLocation().reportSemanticError(message);
                        } else if (!this.portReference.getId().equals(tempPortReference.getId())) {
                            message = MessageFormat.format("The `{0}'' operation refers to a different port than the previous `call'' statement: `{1}'' was expected instead of `{2}''", statement.getStatementName(), this.portReference.getId().getDisplayName(), tempPortReference.getId().getDisplayName());
                            tempPortReference.getLocation().reportSemanticError(message);
                        }
                        TemplateInstance instance = ((Getreply_Statement)statement).getReceiveParameter();
                        if (instance == null || (tempSignature = instance.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE)) == null || signature == null || signature.isCompatible(timestamp, tempSignature, null, null, null)) continue block5;
                        String message2 = MessageFormat.format(GETRPELYTOWRONGSIGNATURE, signature.getTypename(), tempSignature.getTypename());
                        instance.getLocation().reportSemanticError(message2);
                        continue block5;
                    }
                    case S_CATCH: {
                        String message;
                        Reference tempPortReference = ((Catch_Statement)statement).getPortReference();
                        if (tempPortReference == null) {
                            message = MessageFormat.format("The `{0}'' operation must refer to the same port as the previous `call'' statement: `{1}'' was expected instead of `any port''", statement.getStatementName(), this.portReference.getId().getDisplayName());
                            statement.getLocation().reportSemanticError(message);
                        } else if (!this.portReference.getId().equals(tempPortReference.getId())) {
                            message = MessageFormat.format("The `{0}'' operation refers to a different port than the previous `call'' statement: `{1}'' was expected instead of `{2}''", statement.getStatementName(), this.portReference.getId().getDisplayName(), tempPortReference.getId().getDisplayName());
                            tempPortReference.getLocation().reportSemanticError(message);
                        }
                        Signature_Type tempSignature = ((Catch_Statement)statement).getSignatureType();
                        if (tempSignature == null || signature == null || signature.isCompatible(timestamp, tempSignature, null, null, null)) continue block5;
                        String message3 = MessageFormat.format("The `catch'' operation refers to a different signature than the previous `call'' statement: `{0}'' was expected instead of `{1}''", signature.getTypename(), tempSignature.getTypename());
                        statement.getLocation().reportSemanticError(message3);
                        continue block5;
                    }
                }
            }
        }
        if (this.timerValue != null && !hasCatchTimeout) {
            this.location.reportSemanticWarning("The call operation has a timer, but the timeout expection is not cought");
        }
    }

    @Override
    public void checkAllowedInterleave() {
        if (this.altGuards != null) {
            this.altGuards.checkAllowedInterleave();
        }
    }

    @Override
    public void postCheck() {
        if (this.altGuards != null) {
            this.altGuards.postCheck();
        }
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.altGuards != null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(293);
        if (this.toClause != null) {
            return result;
        }
        result.add(162);
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.portReference != null) {
            this.portReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.portReference.getLocation());
        }
        if (this.parameter != null) {
            this.parameter.updateSyntax(reparser, false);
            reparser.updateLocation(this.parameter.getLocation());
        }
        if (this.timerValue != null) {
            this.timerValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.timerValue.getLocation());
        }
        if (this.toClause instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.toClause)).updateSyntax(reparser, false);
            reparser.updateLocation(this.toClause.getLocation());
        } else if (this.toClause != null) {
            throw new ReParseException();
        }
        if (this.altGuards != null) {
            this.altGuards.updateSyntax(reparser, false);
            reparser.updateLocation(this.altGuards.getLocation());
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectTimestamp.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.portReference != null) {
            this.portReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.parameter != null) {
            this.parameter.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.timerValue != null) {
            this.timerValue.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.toClause != null) {
            this.toClause.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.altGuards != null) {
            this.altGuards.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.portReference != null && !this.portReference.accept(v)) {
            return false;
        }
        if (this.parameter != null && !this.parameter.accept(v)) {
            return false;
        }
        if (this.timerValue != null && !this.timerValue.accept(v)) {
            return false;
        }
        if (this.toClause != null && !this.toClause.accept(v)) {
            return false;
        }
        if (this.altGuards != null && !this.altGuards.accept(v)) {
            return false;
        }
        return this.redirectTimestamp == null || this.redirectTimestamp.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        ExpressionStruct expression = new ExpressionStruct();
        this.portReference.generateCode(aData, expression);
        expression.expression.append(".call(");
        this.parameter.generateCode(aData, expression, TemplateRestriction.Restriction_type.TR_NONE);
        if (this.toClause != null) {
            expression.expression.append(", ");
            this.toClause.generateCodeExpression(aData, expression, true);
        }
        expression.expression.append(", ");
        if (this.redirectTimestamp == null) {
            expression.expression.append("null");
        } else {
            this.redirectTimestamp.generateCode(aData, expression);
        }
        expression.expression.append(')');
        expression.mergeExpression(source);
        if (this.altGuards != null) {
            source.append("{\n");
            String timerName = aData.getTemporaryVariableName();
            if (this.timerValue != null) {
                aData.addBuiltinTypeImport("TitanTimer");
                this.timerValue.getLocation().update_location_object(aData, source);
                source.append(MessageFormat.format("final TitanTimer {0} = new TitanTimer(null);\n", timerName));
                expression = new ExpressionStruct();
                expression.expression.append(MessageFormat.format("{0}.start(", timerName));
                this.timerValue.generateCodeExpression(aData, expression, false);
                expression.expression.append(')');
                expression.mergeExpression(source);
            }
            this.altGuards.generateCodeCallBody(aData, source, aData.getTemporaryVariableName(), timerName, false);
            source.append("}\n");
        }
    }
}

