/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types.subtypes;

import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.LimitType;

public final class RealLimit
extends LimitType {
    public static final RealLimit MAXIMUM = new RealLimit(Double.POSITIVE_INFINITY);
    public static final RealLimit MINIMUM = new RealLimit(Double.NEGATIVE_INFINITY);
    private final ValueType valueType;
    private final double value;

    private RealLimit(ValueType vt, double d) {
        this.valueType = vt;
        this.value = d;
    }

    public RealLimit(double d) {
        if (Double.isNaN(d)) {
            ErrorReporter.INTERNAL_ERROR((String)"NaN range limit");
        }
        this.valueType = ValueType.EXACT;
        this.value = d;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public LimitType decrement() {
        switch (this.valueType) {
            case UPPER: {
                return new RealLimit(this.value);
            }
        }
        return new RealLimit(ValueType.LOWER, this.value);
    }

    @Override
    public LimitType.Type getType() {
        return LimitType.Type.REAL;
    }

    @Override
    public LimitType increment() {
        switch (this.valueType) {
            case LOWER: {
                return new RealLimit(this.value);
            }
        }
        return new RealLimit(ValueType.UPPER, this.value);
    }

    @Override
    public boolean isAdjacent(LimitType other) {
        RealLimit rl = (RealLimit)other;
        return Double.compare(this.value, rl.value) == 0 && this.valueType.value() + 1 == rl.valueType.value();
    }

    @Override
    public void toString(StringBuilder sb) {
        if (this.valueType != ValueType.EXACT) {
            sb.append('!');
        }
        sb.append(this.value);
    }

    @Override
    public int compareTo(LimitType o) {
        RealLimit rl = (RealLimit)o;
        int rv = Double.compare(this.value, rl.value);
        return rv != 0 ? rv : this.valueType.value() - rl.valueType.value();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RealLimit)) {
            return false;
        }
        RealLimit other = (RealLimit)obj;
        return this.valueType == other.valueType && Double.compare(this.value, other.value) == 0;
    }

    public int hashCode() {
        return (int)this.value;
    }

    public static enum ValueType {
        LOWER(-1),
        EXACT(0),
        UPPER(1);

        private final int value;

        private ValueType(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

