/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.application;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.wizards.TITANProjectOpener;

public final class ImportProject
implements IApplication {
    private Integer closeWorkspace() {
        try {
            ResourcesPlugin.getWorkspace().save(true, null);
            return EXIT_OK;
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while closing workspace", (Throwable)e);
            return -1;
        }
    }

    public Object start(IApplicationContext context) throws Exception {
        IProject[] projects;
        Platform.getBundle((String)"org.eclipse.titan.designer").start();
        String[] projectNames = (String[])context.getArguments().get("application.args");
        if (projectNames.length != 1) {
            System.out.println("This application takes as parameter the path of the project it should import to the workspace.");
            return -1;
        }
        Path projectPath = new Path(projectNames[0]);
        for (IProject project : projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            if (project == null || !project.getName().equals(projectPath.lastSegment())) continue;
            System.out.println("The project with name `" + projectPath.lastSegment() + "' already exists in the workspace.");
            return this.closeWorkspace();
        }
        try {
            IProject project = TITANProjectOpener.open((IPath)projectPath);
            if (TITANProjectOpener.check(project)) {
                System.out.println("The project with name `" + project.getName() + "' is imported in the workspace!");
            } else {
                System.out.println("The project with name `" + project.getName() + "' is imported in the workspace, but it is not a Titan project.");
            }
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((String)("Error while imporing project with name `" + projectPath.lastSegment() + "' in the workspace"), (Throwable)e);
            this.closeWorkspace();
            return -1;
        }
        return this.closeWorkspace();
    }

    public void stop() {
    }
}

