/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.compiler.BuildTimestamp;
import org.eclipse.titan.designer.compiler.ProjectSourceCompiler;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.license.LicenseValidator;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;

public class TITANJavaBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.titan.designer.core.TITANJavaBuilder";

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        if (!LicenseValidator.check()) {
            return project.getReferencedProjects();
        }
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean reportDebugInformation = store.getBoolean("org.eclipse.titan.designer.displayDebugInformation");
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.beginTask("Build", 2);
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser(project);
        sourceParser.makefileCreatingAnalyzeAll();
        progress.worked(1);
        BuildTimestamp timestamp = BuildTimestamp.getNewBuildCounter();
        SubMonitor codeGeneratorMonitor = progress.newChild(1);
        Collection<Module> localModules = sourceParser.getModules();
        Set<String> knownModuleNames = sourceParser.getKnownModuleNames();
        codeGeneratorMonitor.beginTask("Checking prerequisites", localModules.size() + 1);
        int generatedCount = 0;
        for (Module module : localModules) {
            if (codeGeneratorMonitor.isCanceled()) break;
            if ((kind == 10 || kind == 9) && !module.shouldBeGenerated()) continue;
            TITANDebugConsole.println("Generating code for module `" + module.getIdentifier().getDisplayName() + "'");
            try {
                if (ProjectSourceCompiler.compile(timestamp, module, reportDebugInformation)) {
                    ++generatedCount;
                }
            }
            catch (Exception e) {
                ErrorReporter.logExceptionStackTrace((String)("While generating Java code for module " + module.getIdentifier().getDisplayName()), (Throwable)e);
            }
            codeGeneratorMonitor.worked(1);
        }
        TITANDebugConsole.println("Generated " + generatedCount + " Java files.");
        TITANDebugConsole.println("Generating code for single main");
        try {
            ProjectSourceCompiler.generateGeneratedPackageInfo(project);
            ProjectSourceCompiler.generateSingleMain(project, knownModuleNames);
            ProjectSourceCompiler.generateParallelMain(project, knownModuleNames);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)"While generating Java code for main module ", (Throwable)e);
        }
        codeGeneratorMonitor.worked(1);
        codeGeneratorMonitor.done();
        return new IProject[0];
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.subTask("Deleting java_src/org");
        IProject project = this.getProject();
        IFolder folder = project.getFolder("java_src/org");
        if (folder.exists()) {
            try {
                folder.delete(true, (IProgressMonitor)progress.newChild(40));
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)"While cleaning generated code in java_src", (Throwable)e);
            }
        }
        progress.subTask("Deleting java_bin");
        folder = project.getFolder("java_bin");
        if (folder.exists()) {
            try {
                folder.delete(true, (IProgressMonitor)progress.newChild(50));
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)"While cleaning generated code in java_bin", (Throwable)e);
            }
        }
        progress.subTask("Deleting temp");
        folder = project.getFolder("temp");
        if (folder.exists()) {
            try {
                folder.delete(true, (IProgressMonitor)progress.newChild(10));
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)"While cleaning files in temp", (Throwable)e);
            }
        }
        try {
            ProjectSourceCompiler.generateGeneratedPackageInfo(project);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)"While generating Java package_info ", (Throwable)e);
        }
        progress.done();
    }

    public static boolean isBuilderEnabled(IProject project) {
        IProjectDescription description;
        if (!project.isAccessible()) {
            return false;
        }
        try {
            description = project.getDescription();
        }
        catch (CoreException e) {
            return false;
        }
        ICommand[] cmds = description.getBuildSpec();
        for (int i = 0; i < cmds.length; ++i) {
            if (!BUILDER_ID.equals(cmds[i].getBuilderName())) continue;
            return true;
        }
        return false;
    }
}

