/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor.contentassist;

import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.editors.CompletionProposal;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContextInfo;
import org.eclipse.titan.designer.graphics.ImageCache;

public class ImportContext
extends ProposalContext {
    public ImportContext(ProposalContextInfo proposalContextInfo) {
        super(proposalContextInfo);
        this.doFallback = false;
    }

    @Override
    public void getProposals(ProposalCollector propCollector) {
        Set<String> knownModuleNames = this.sourceParser.getKnownModuleNames();
        knownModuleNames.remove(this.proposalContextInfo.module.getIdentifier().getDisplayName());
        List<Module> importedModules = this.proposalContextInfo.module.getImportedModules();
        for (Module importedModule : importedModules) {
            knownModuleNames.remove(importedModule.getIdentifier().getDisplayName());
        }
        String prefix = this.getPrefix();
        int replacementOffset = this.proposalContextInfo.offset - prefix.length();
        int replacementLength = prefix.length();
        for (String knownModuleName : knownModuleNames) {
            Module tempModule = this.sourceParser.getModuleByName(knownModuleName);
            String tempModuleName = tempModule.getIdentifier().getDisplayName();
            CompletionProposal proposal = new CompletionProposal(tempModuleName, replacementOffset, replacementLength, tempModuleName.length(), ImageCache.getImage(tempModule.getOutlineIcon()), new StyledString(tempModuleName), null, tempModule.getHoverContent(null), tempModuleName.toLowerCase().startsWith(prefix.toLowerCase()) ? 2 : 1);
            propCollector.addProposal(proposal);
            String replacementString = tempModuleName + " all";
            CompletionProposal proposal2 = new CompletionProposal(replacementString, replacementOffset, replacementLength, replacementString.length(), ImageCache.getImage(tempModule.getOutlineIcon()), new StyledString(replacementString), null, tempModule.getHoverContent(null), tempModuleName.toLowerCase().startsWith(prefix.toLowerCase()) ? 2 : 1);
            propCollector.addProposal(proposal2);
        }
        propCollector.sortAll();
    }
}

