/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.utils;

import java.util.Map;
import org.eclipse.titan.common.utils.Joiner;

public class MapJoiner {
    private final Joiner simpleJoiner;
    private final String keyValueDelimiter;

    public MapJoiner(String entryDelimiter, String keyValueDelimiter) {
        this.simpleJoiner = new Joiner(entryDelimiter);
        this.keyValueDelimiter = keyValueDelimiter;
    }

    public <K, V> MapJoiner join(K key, V value) {
        this.simpleJoiner.join(String.valueOf(key) + this.keyValueDelimiter + String.valueOf(value));
        return this;
    }

    public MapJoiner join(Map<?, ?> mapToJoin) {
        for (Map.Entry<?, ?> entry : mapToJoin.entrySet()) {
            this.join(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public String toString() {
        return this.simpleJoiner.toString();
    }
}

