/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import org.eclipse.titan.runtime.core.Index_Redirect;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TitanAlt_Status;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanTimer;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanTimer_Array<T extends TitanTimer>
extends TitanTimer {
    TitanTimer[] array_elements;
    String[] names;
    public Class<T> clazz;
    int array_size;
    int indexOffset;

    public TitanTimer_Array(TitanTimer_Array<T> otherValue) {
        this.clazz = otherValue.clazz;
        this.array_size = otherValue.array_size;
        this.indexOffset = otherValue.indexOffset;
        this.array_elements = new TitanTimer[this.array_size];
        for (int i = 0; i < this.array_size; ++i) {
            try {
                TitanTimer helper = (TitanTimer)this.clazz.newInstance();
                helper.operator_assign(otherValue.array_elements[i]);
                this.array_elements[i] = helper;
                continue;
            }
            catch (InstantiationException e) {
                throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.clazz, e));
            }
            catch (IllegalAccessException e) {
                throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.clazz, e));
            }
        }
    }

    TitanTimer_Array<T> operator_assign(TitanTimer_Array<T> otherValue) {
        this.array_size = otherValue.array_size;
        this.indexOffset = otherValue.indexOffset;
        this.array_elements = new TitanTimer[this.array_size];
        for (int i = 0; i < otherValue.array_size; ++i) {
            try {
                TitanTimer helper = (TitanTimer)this.clazz.newInstance();
                helper.operator_assign((TitanTimer)otherValue.array_element(i));
                this.array_elements[i] = helper;
                continue;
            }
            catch (InstantiationException e) {
                throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.clazz, e));
            }
            catch (IllegalAccessException e) {
                throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.clazz, e));
            }
        }
        return this;
    }

    public TitanTimer_Array(Class<T> clazz, int size, int offset) {
        this.clazz = clazz;
        this.indexOffset = offset;
        this.array_elements = new TitanTimer[size];
        this.set_size(size);
        this.names = new String[size];
    }

    public void set_size(int length) {
        for (int i = this.array_size; i < length; ++i) {
            try {
                TitanTimer empty;
                this.array_elements[i] = empty = (TitanTimer)this.clazz.newInstance();
                continue;
            }
            catch (InstantiationException e) {
                throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.clazz, e));
            }
            catch (IllegalAccessException e) {
                throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.clazz, e));
            }
        }
        this.array_size = length;
    }

    public void set_offset(int offset) {
        this.indexOffset = offset;
    }

    public T get_at(int index) {
        return (T)this.array_elements[TitanTimer_Array.get_timer_array_index(index, this.array_size, this.indexOffset)];
    }

    public T get_at(TitanInteger index) {
        return (T)this.array_elements[TitanTimer_Array.get_timer_array_index(index, this.array_size, this.indexOffset)];
    }

    public T constGet_at(int index) {
        return (T)this.array_elements[TitanTimer_Array.get_timer_array_index(index, this.array_size, this.indexOffset)];
    }

    public T constGet_at(TitanInteger index) {
        return (T)this.array_elements[TitanTimer_Array.get_timer_array_index(index, this.array_size, this.indexOffset)];
    }

    public T array_element(int index) {
        return (T)this.array_elements[index];
    }

    public T array_element(TitanInteger index) {
        index.must_bound("Accessing an element of an array using an unbound index.");
        return (T)this.array_elements[index.get_int()];
    }

    public int n_elem() {
        return this.array_size;
    }

    public int size_of() {
        return this.array_size;
    }

    public int lengthof() {
        return this.array_size;
    }

    @Override
    public void set_name(String name_string) {
        for (int i = 0; i < this.array_size; ++i) {
            this.names[i] = name_string + '[' + (this.indexOffset + i) + ']';
            this.array_elements[i].set_name(this.names[i]);
        }
    }

    @Override
    public void log() {
        TTCN_Logger.log_event_str("{ ");
        for (int v_index = 0; v_index < this.array_size; ++v_index) {
            if (v_index > 0) {
                TTCN_Logger.log_event_str(", ");
            }
            this.array_elements[v_index].log();
        }
        TTCN_Logger.log_event_str(" }");
    }

    public static int get_timer_array_index(int indexValue, int arraySize, int indexOffset) {
        if (arraySize < 0) {
            throw new TtcnError("Invalid array size");
        }
        if (indexValue < indexOffset) {
            throw new TtcnError("Index underflow when accessing an element of a timer array. The index value should be between " + indexOffset + " and " + (indexOffset + arraySize - 1) + " instead of " + indexValue + ".");
        }
        int result = indexValue - indexOffset;
        if (result >= arraySize) {
            throw new TtcnError("Index underflow when accessing an element of a timer array. The index value should be between " + indexOffset + " and " + (indexOffset + arraySize - 1) + " instead of " + indexValue + ".");
        }
        return result;
    }

    public static int get_timer_array_index(TitanInteger indexValue, int arraySize, int indexOffset) {
        indexValue.must_bound("Accessing an element of a timer array using an unbound index.");
        return TitanTimer_Array.get_timer_array_index(indexValue.get_int(), arraySize, indexOffset);
    }

    @Override
    public TitanAlt_Status timeout(Index_Redirect index_redirect) {
        if (index_redirect != null) {
            index_redirect.incr_pos();
        }
        TitanAlt_Status result = TitanAlt_Status.ALT_NO;
        for (int i = 0; i < this.array_size; ++i) {
            TitanAlt_Status ret_val = this.array_elements[i].timeout(index_redirect);
            if (ret_val == TitanAlt_Status.ALT_YES) {
                if (index_redirect != null) {
                    index_redirect.add_index(i + this.indexOffset);
                }
                result = ret_val;
                break;
            }
            if (ret_val != TitanAlt_Status.ALT_REPEAT && (ret_val != TitanAlt_Status.ALT_MAYBE || result != TitanAlt_Status.ALT_NO)) continue;
            result = ret_val;
        }
        return result;
    }

    @Override
    public boolean running(Index_Redirect index_redirect) {
        if (index_redirect != null) {
            index_redirect.incr_pos();
        }
        boolean ret_val = false;
        for (int i = 0; i < this.array_size; ++i) {
            ret_val = this.array_elements[i].running(index_redirect);
            if (!ret_val) continue;
            if (index_redirect == null) break;
            index_redirect.add_index(i + this.indexOffset);
            break;
        }
        if (index_redirect != null) {
            index_redirect.decr_pos();
        }
        return ret_val;
    }
}

